/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb;

public enum CompressionType {
    NONE(0),
    SNAPPY(1),
    ZLIB(2),
    ZLIB_RAW(4);

    private final int persistentId;

    private CompressionType(int persistentId) {
        this.persistentId = persistentId;
    }

    public static CompressionType getCompressionTypeByPersistentId(int persistentId) {
        for (CompressionType compressionType : CompressionType.values()) {
            if (compressionType.persistentId != persistentId) continue;
            return compressionType;
        }
        throw new IllegalArgumentException("Unknown persistentId " + persistentId);
    }

    public int persistentId() {
        return this.persistentId;
    }
}

