/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.nbt.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class VarInts {
    private VarInts() {
    }

    public static void writeInt(DataOutput buffer, int integer) throws IOException {
        VarInts.encodeUnsigned(buffer, integer << 1 ^ integer >> 31);
    }

    public static int readInt(DataInput buffer) throws IOException {
        int n = (int)VarInts.decodeUnsigned(buffer);
        return n >>> 1 ^ -(n & 1);
    }

    public static void writeUnsignedInt(DataOutput buffer, long integer) throws IOException {
        VarInts.encodeUnsigned(buffer, integer);
    }

    public static int readUnsignedInt(DataInput buffer) throws IOException {
        return (int)VarInts.decodeUnsigned(buffer);
    }

    public static void writeLong(DataOutput buffer, long longInteger) throws IOException {
        VarInts.encodeUnsigned(buffer, longInteger << 1 ^ longInteger >> 63);
    }

    public static long readLong(DataInput buffer) throws IOException {
        long n = VarInts.decodeUnsigned(buffer);
        return n >>> 1 ^ -(n & 1L);
    }

    public static void writeUnsignedLong(DataOutput buffer, long longInteger) throws IOException {
        VarInts.encodeUnsigned(buffer, longInteger);
    }

    public static long readUnsignedLong(DataInput buffer) throws IOException {
        return VarInts.decodeUnsigned(buffer);
    }

    private static long decodeUnsigned(DataInput buffer) throws IOException {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = buffer.readByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new ArithmeticException("Varint was too large");
    }

    private static void encodeUnsigned(DataOutput buffer, long value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                buffer.writeByte((int)value);
                return;
            }
            buffer.writeByte((byte)((int)value & 0x7F | 0x80));
            value >>>= 7;
        }
    }
}

