/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.nbt.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class UnmodifiableEntrySet<K, V>
implements Set<Map.Entry<K, V>>,
Collection<Map.Entry<K, V>> {
    private final Set<? extends Map.Entry<K, V>> entrySet;

    public UnmodifiableEntrySet(Set<? extends Map.Entry<K, V>> entrySet) {
        this.entrySet = entrySet;
    }

    static <K, V> Consumer<Map.Entry<K, V>> entryConsumer(Consumer<? super Map.Entry<K, V>> action) {
        return e -> action.accept(new UnmodifiableEntry(e));
    }

    @Override
    public void forEach(Consumer<? super Map.Entry<K, V>> action) {
        Objects.requireNonNull(action);
        this.entrySet.forEach(UnmodifiableEntrySet.entryConsumer(action));
    }

    @Override
    public int hashCode() {
        return this.entrySet.hashCode();
    }

    @Override
    public int size() {
        return this.entrySet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet.isEmpty();
    }

    public String toString() {
        return this.entrySet.toString();
    }

    @Override
    public boolean add(Map.Entry<K, V> e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Spliterator<Map.Entry<K, V>> spliterator() {
        return new UnmodifiableEntrySetSpliterator(this.entrySet.spliterator());
    }

    @Override
    public Stream<Map.Entry<K, V>> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @Override
    public Stream<Map.Entry<K, V>> parallelStream() {
        return StreamSupport.stream(this.spliterator(), true);
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new Iterator<Map.Entry<K, V>>(){
            private final Iterator<? extends Map.Entry<? extends K, ? extends V>> i;
            {
                this.i = UnmodifiableEntrySet.this.entrySet.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                return new UnmodifiableEntry(this.i.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Object[] toArray() {
        Object[] a = this.entrySet.toArray();
        for (int i = 0; i < a.length; ++i) {
            a[i] = new UnmodifiableEntry((Map.Entry)a[i]);
        }
        return a;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        T[] arr = this.entrySet.toArray(a.length == 0 ? a : Arrays.copyOf(a, 0));
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = new UnmodifiableEntry((Map.Entry)arr[i]);
        }
        if (arr.length > a.length) {
            return arr;
        }
        System.arraycopy(arr, 0, a, 0, arr.length);
        if (a.length > arr.length) {
            a[arr.length] = null;
        }
        return a;
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        return this.entrySet.contains(new UnmodifiableEntry((Map.Entry)o));
    }

    @Override
    public boolean containsAll(Collection<?> coll) {
        for (Object e : coll) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        Set s2 = (Set)o;
        if (s2.size() != this.entrySet.size()) {
            return false;
        }
        return this.containsAll(s2);
    }

    private static class UnmodifiableEntry<K, V>
    implements Map.Entry<K, V> {
        private Map.Entry<? extends K, ? extends V> e;

        UnmodifiableEntry(Map.Entry<? extends K, ? extends V> e) {
            this.e = Objects.requireNonNull(e);
        }

        @Override
        public K getKey() {
            return this.e.getKey();
        }

        @Override
        public V getValue() {
            return this.e.getValue();
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            return this.e.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry t2 = (Map.Entry)o;
            return Objects.equals(this.e.getKey(), t2.getKey()) && Objects.equals(this.e.getValue(), t2.getValue());
        }

        public String toString() {
            return this.e.toString();
        }
    }

    static final class UnmodifiableEntrySetSpliterator<K, V>
    implements Spliterator<Map.Entry<K, V>> {
        final Spliterator<Map.Entry<K, V>> s;

        UnmodifiableEntrySetSpliterator(Spliterator<Map.Entry<K, V>> s2) {
            this.s = s2;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Map.Entry<K, V>> action) {
            Objects.requireNonNull(action);
            return this.s.tryAdvance(UnmodifiableEntrySet.entryConsumer(action));
        }

        @Override
        public void forEachRemaining(Consumer<? super Map.Entry<K, V>> action) {
            Objects.requireNonNull(action);
            this.s.forEachRemaining(UnmodifiableEntrySet.entryConsumer(action));
        }

        @Override
        public Spliterator<Map.Entry<K, V>> trySplit() {
            Spliterator<Map.Entry<K, V>> split = this.s.trySplit();
            return split == null ? null : new UnmodifiableEntrySetSpliterator<K, V>(split);
        }

        @Override
        public long estimateSize() {
            return this.s.estimateSize();
        }

        @Override
        public long getExactSizeIfKnown() {
            return this.s.getExactSizeIfKnown();
        }

        @Override
        public int characteristics() {
            return this.s.characteristics();
        }

        @Override
        public boolean hasCharacteristics(int characteristics) {
            return this.s.hasCharacteristics(characteristics);
        }

        @Override
        public Comparator<? super Map.Entry<K, V>> getComparator() {
            return this.s.getComparator();
        }
    }
}

