/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.blockstateupdater;

import org.cloudburstmc.blockstateupdater.BlockStateUpdater;
import org.cloudburstmc.blockstateupdater.util.tagupdater.CompoundTagUpdaterContext;

public class BlockStateUpdater_1_14_0
implements BlockStateUpdater {
    public static final BlockStateUpdater INSTANCE = new BlockStateUpdater_1_14_0();

    private static void addRailUpdater(String name, CompoundTagUpdaterContext context) {
        context.addUpdater(1, 14, 0).match("name", name).visit("states").edit("rail_direction", helper -> {
            int direction = (Integer)helper.getTag();
            if (direction > 5) {
                direction = 0;
            }
            helper.replaceWith("rail_direction", direction);
        });
    }

    public static void addMaxStateUpdater(String name, String state, int maxValue, CompoundTagUpdaterContext context) {
        context.addUpdater(1, 14, 0).match("name", name).visit("states").edit(state, helper -> {
            int value = (Integer)helper.getTag();
            if (value > maxValue) {
                value = maxValue;
            }
            helper.replaceWith(state, value);
        });
    }

    private static int convertWeirdoDirectionToFacing(int weirdoDirection) {
        switch (weirdoDirection) {
            case 0: {
                return 5;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 3;
            }
        }
        return 2;
    }

    @Override
    public void registerUpdaters(CompoundTagUpdaterContext context) {
        context.addUpdater(1, 14, 0).match("name", "minecraft:frame").visit("states").edit("weirdo_direction", helper -> {
            int tag = (Integer)helper.getTag();
            int newDirection = BlockStateUpdater_1_14_0.convertWeirdoDirectionToFacing(tag);
            helper.replaceWith("facing_direction", newDirection);
        });
        BlockStateUpdater_1_14_0.addRailUpdater("minecraft:golden_rail", context);
        BlockStateUpdater_1_14_0.addRailUpdater("minecraft:detector_rail", context);
        BlockStateUpdater_1_14_0.addRailUpdater("minecraft:activator_rail", context);
        BlockStateUpdater_1_14_0.addMaxStateUpdater("minecraft:rail", "rail_direction", 9, context);
        BlockStateUpdater_1_14_0.addMaxStateUpdater("minecraft:cake", "bite_counter", 6, context);
        BlockStateUpdater_1_14_0.addMaxStateUpdater("minecraft:chorus_flower", "age", 5, context);
        BlockStateUpdater_1_14_0.addMaxStateUpdater("minecraft:cocoa", "age", 2, context);
        BlockStateUpdater_1_14_0.addMaxStateUpdater("minecraft:composter", "composter_fill_level", 8, context);
    }

    private BlockStateUpdater_1_14_0() {
    }
}

