/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.blockstateupdater;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cloudburstmc.blockstateupdater.BlockStateUpdater;
import org.cloudburstmc.blockstateupdater.util.tagupdater.CompoundTagUpdaterContext;

public class BlockStateUpdaterBase
implements BlockStateUpdater {
    public static final BlockStateUpdater INSTANCE;
    public static final Map<String, Map<String, Object>[]> LEGACY_BLOCK_DATA_MAP;
    private static final ObjectMapper JSON_MAPPER;

    private static Map<String, Object> convertStateToCompound(JsonNode node) {
        LinkedHashMap<String, Object> tag = new LinkedHashMap<String, Object>();
        Iterator<Map.Entry<String, JsonNode>> iterator = node.fields();
        block5: while (iterator.hasNext()) {
            Map.Entry<String, JsonNode> entry = iterator.next();
            String name = entry.getKey();
            JsonNode value = entry.getValue();
            switch (value.getNodeType()) {
                case BOOLEAN: {
                    tag.put(name, value.booleanValue());
                    continue block5;
                }
                case NUMBER: {
                    tag.put(name, value.intValue());
                    continue block5;
                }
                case STRING: {
                    tag.put(name, value.textValue());
                    continue block5;
                }
            }
            throw new UnsupportedOperationException("Invalid state type");
        }
        return tag;
    }

    @Override
    public void registerUpdaters(CompoundTagUpdaterContext context) {
        context.addUpdater(0, 0, 0).regex("name", "minecraft:.+").regex("val", "[0-9]+").addCompound("states").tryEdit("states", helper -> {
            Map<String, Object> tag = helper.getCompoundTag();
            Map<String, Object> parent = helper.getParent();
            String id = (String)parent.get("name");
            short val = (Short)parent.get("val");
            Map<String, Object>[] statesArray = LEGACY_BLOCK_DATA_MAP.get(id);
            if (statesArray != null) {
                if (val >= statesArray.length) {
                    val = 0;
                }
                tag.putAll(statesArray[val]);
            }
        }).remove("val");
    }

    private BlockStateUpdaterBase() {
    }

    static {
        JsonNode node;
        INSTANCE = new BlockStateUpdaterBase();
        LEGACY_BLOCK_DATA_MAP = new HashMap<String, Map<String, Object>[]>();
        JSON_MAPPER = new ObjectMapper();
        try (InputStream stream = BlockStateUpdater.class.getClassLoader().getResourceAsStream("legacy_block_data_map.json");){
            node = JSON_MAPPER.readTree(stream);
        }
        catch (IOException e) {
            throw new AssertionError("Error loading legacy block data map", e);
        }
        Iterator<Map.Entry<String, JsonNode>> iterator = node.fields();
        while (iterator.hasNext()) {
            Map.Entry<String, JsonNode> entry = iterator.next();
            String name = entry.getKey();
            JsonNode stateNodes = entry.getValue();
            int size = stateNodes.size();
            Map[] states = new Map[size];
            for (int i = 0; i < size; ++i) {
                states[i] = BlockStateUpdaterBase.convertStateToCompound(stateNodes.get(i));
            }
            LEGACY_BLOCK_DATA_MAP.put(name, states);
        }
    }
}

