/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.unsafe.util;

import lombok.NonNull;
import net.daporkchop.lib.unsafe.PUnsafe;
import net.daporkchop.lib.unsafe.capability.Releasable;
import net.daporkchop.lib.unsafe.util.exception.AlreadyReleasedException;

public abstract class AbstractReleasable
implements Releasable {
    private static final long RELEASED_OFFSET = PUnsafe.pork_getOffset(AbstractReleasable.class, "released");
    private volatile int released = 0;

    @Override
    public void release() throws AlreadyReleasedException {
        if (!PUnsafe.compareAndSwapInt(this, RELEASED_OFFSET, 0, 1)) {
            throw new AlreadyReleasedException();
        }
        this.doRelease();
    }

    protected abstract void doRelease();

    protected final void assertNotReleased() throws AlreadyReleasedException {
        if (this.released != 0) {
            throw new AlreadyReleasedException();
        }
    }

    public static abstract class Synchronized
    extends AbstractReleasable {
        protected final Object mutex;

        public Synchronized() {
            this.mutex = this;
        }

        public Synchronized(@NonNull Object mutex) {
            if (mutex == null) {
                throw new NullPointerException("mutex");
            }
            this.mutex = mutex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() throws AlreadyReleasedException {
            Object object = this.mutex;
            synchronized (object) {
                super.release();
            }
        }
    }
}

