/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.unsafe.cleaner;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.NonNull;
import net.daporkchop.lib.unsafe.PCleaner;
import net.daporkchop.lib.unsafe.PUnsafe;
import sun.misc.Cleaner;

public final class SunCleaner
extends PCleaner {
    protected static final long CLEANER_NEXT_OFFSET = PUnsafe.pork_getOffset(Cleaner.class, "next");
    protected static final long CLEANER_THUNK_OFFSET = PUnsafe.pork_getOffset(Cleaner.class, "thunk");
    protected static final Predicate<Cleaner> CLEANER_REMOVE;
    protected static final Function<Cleaner, Cleaner> CLEANER_ADD;
    @NonNull
    private final Cleaner delegate;

    public SunCleaner(@NonNull Object o, @NonNull Runnable cleaner) {
        if (o == null) {
            throw new NullPointerException("o");
        }
        if (cleaner == null) {
            throw new NullPointerException("cleaner");
        }
        this.delegate = Cleaner.create((Object)o, (Runnable)cleaner);
    }

    @Override
    public boolean clean() {
        if (CLEANER_REMOVE.test(this.delegate)) {
            try {
                ((Runnable)PUnsafe.getObject(this.delegate, CLEANER_THUNK_OFFSET)).run();
                PUnsafe.putObject(this.delegate, CLEANER_THUNK_OFFSET, null);
            }
            catch (Throwable t2) {
                if (System.err != null) {
                    new Error("Cleaner terminated abnormally", t2).printStackTrace();
                }
                System.exit(1);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasRun() {
        return PUnsafe.getObject(this.delegate, CLEANER_NEXT_OFFSET) == this.delegate;
    }

    @NonNull
    public Cleaner getDelegate() {
        return this.delegate;
    }

    static {
        try {
            Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
            constructor.setAccessible(true);
            MethodHandles.Lookup lookup = (MethodHandles.Lookup)constructor.newInstance(Cleaner.class, -1);
            PUnsafe.ensureClassInitialized(Cleaner.class);
            PUnsafe.ensureClassInitialized(Predicate.class);
            MethodType targetType = MethodType.methodType(Boolean.TYPE, Cleaner.class);
            CallSite site = LambdaMetafactory.metafactory(lookup, "test", MethodType.methodType(Predicate.class), MethodType.methodType(Boolean.TYPE, Object.class), lookup.findStatic(Cleaner.class, "remove", targetType), targetType);
            CLEANER_REMOVE = site.getTarget().invoke();
            PUnsafe.ensureClassInitialized(Function.class);
            targetType = MethodType.methodType(Cleaner.class, Cleaner.class);
            site = LambdaMetafactory.metafactory(lookup, "apply", MethodType.methodType(Function.class), MethodType.methodType(Object.class, Object.class), lookup.findStatic(Cleaner.class, "add", targetType), targetType);
            CLEANER_ADD = site.getTarget().invoke();
        }
        catch (NoClassDefFoundError e) {
            System.err.println("sun.misc.Cleaner does not exist!");
            e.printStackTrace();
            PUnsafe.throwException(e);
            throw new RuntimeException(e);
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to initialize SunCleaner!", e);
        }
    }
}

