/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.unsafe.cleaner;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ThreadFactory;
import lombok.NonNull;
import net.daporkchop.lib.unsafe.PCleaner;

public final class Java9Cleaner
extends PCleaner
implements Runnable {
    private static final Class<?> CLEANER_CLASS;
    private static final Class<?> CLEANABLE_CLASS;
    private static final Method CLEANER_REGISTER;
    private static final Method CLEANABLE_RUN;
    private static final Object CLEANER_INSTANCE;
    private final Object cleanable;
    private Runnable thunk;
    private boolean hasRun;

    public Java9Cleaner(@NonNull Object o, @NonNull Runnable cleaner) {
        if (o == null) {
            throw new NullPointerException("o");
        }
        if (cleaner == null) {
            throw new NullPointerException("cleaner");
        }
        this.thunk = cleaner;
        try {
            this.cleanable = CLEANER_REGISTER.invoke(CLEANER_INSTANCE, o, this);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Couldn't register cleaner!", e);
        }
    }

    @Override
    public synchronized void run() {
        if (this.hasRun) {
            throw new IllegalStateException("Cleaner already run!");
        }
        try {
            this.thunk.run();
        }
        finally {
            this.thunk = null;
            this.hasRun = true;
        }
    }

    @Override
    public synchronized boolean clean() {
        if (!this.hasRun) {
            try {
                CLEANABLE_RUN.invoke(this.cleanable, new Object[0]);
                if (!this.hasRun) {
                    throw new IllegalStateException("Cleaner didn't run!");
                }
                return true;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Couldn't run cleaner!", e);
            }
        }
        return false;
    }

    @Override
    public boolean hasRun() {
        return this.hasRun;
    }

    static {
        try {
            CLEANER_CLASS = Class.forName("java.lang.ref.Cleaner");
            CLEANABLE_CLASS = Class.forName("java.lang.ref.Cleaner$Cleanable");
            CLEANER_REGISTER = CLEANER_CLASS.getDeclaredMethod("register", Object.class, Runnable.class);
            CLEANABLE_RUN = CLEANABLE_CLASS.getDeclaredMethod("clean", new Class[0]);
            Method create = CLEANER_CLASS.getDeclaredMethod("create", ThreadFactory.class);
            CLEANER_INSTANCE = create.invoke(null, r -> new Thread(r, "PorkLib cleaner thread"));
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to initialize Java9Cleaner!", e);
        }
    }
}

