/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.unsafe;

import java.lang.reflect.Field;
import lombok.NonNull;
import net.daporkchop.lib.unsafe.PUnsafe;

public final class UnsafeStaticField {
    private final long offset;
    private final Object base;

    public UnsafeStaticField(@NonNull Field field) throws IllegalArgumentException {
        if (field == null) {
            throw new NullPointerException("field");
        }
        if ((field.getModifiers() & 8) == 0) {
            throw new IllegalArgumentException(String.format("Field \"%s\" is not static!", field));
        }
        this.offset = PUnsafe.staticFieldOffset(field);
        this.base = PUnsafe.staticFieldBase(field);
    }

    public UnsafeStaticField(@NonNull Class<?> clazz, @NonNull String name) throws NoSuchFieldException, IllegalArgumentException {
        this(clazz.getDeclaredField(name));
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
    }

    public <T> T getObject() {
        Object value = PUnsafe.getObject(this.base, this.offset);
        return value;
    }

    public boolean getBoolean() {
        return PUnsafe.getBoolean(this.base, this.offset);
    }

    public byte getByte() {
        return PUnsafe.getByte(this.base, this.offset);
    }

    public short getShort() {
        return PUnsafe.getShort(this.base, this.offset);
    }

    public char getChar() {
        return PUnsafe.getChar(this.base, this.offset);
    }

    public int getInt() {
        return PUnsafe.getInt(this.base, this.offset);
    }

    public long getLong() {
        return PUnsafe.getLong(this.base, this.offset);
    }

    public float getFloat() {
        return PUnsafe.getFloat(this.base, this.offset);
    }

    public double getDouble() {
        return PUnsafe.getDouble(this.base, this.offset);
    }

    public <T> void setObject(T value) {
        PUnsafe.putObject(this.base, this.offset, value);
    }

    public void setBoolean(boolean value) {
        PUnsafe.putBoolean(this.base, this.offset, value);
    }

    public void setByte(byte value) {
        PUnsafe.putByte(this.base, this.offset, value);
    }

    public void setShort(short value) {
        PUnsafe.putShort(this.base, this.offset, value);
    }

    public void setChar(char value) {
        PUnsafe.putChar(this.base, this.offset, value);
    }

    public void setInt(int value) {
        PUnsafe.putInt(this.base, this.offset, value);
    }

    public void setLong(long value) {
        PUnsafe.putLong(this.base, this.offset, value);
    }

    public void setFloat(float value) {
        PUnsafe.putFloat(this.base, this.offset, value);
    }

    public void setDouble(double value) {
        PUnsafe.putDouble(this.base, this.offset, value);
    }

    public UnsafeStaticField(long offset, Object base) {
        this.offset = offset;
        this.base = base;
    }

    public long offset() {
        return this.offset;
    }

    public Object base() {
        return this.base;
    }
}

