/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.unsafe;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import lombok.NonNull;
import net.daporkchop.lib.unsafe.PUnsafe;
import net.daporkchop.lib.unsafe.cleaner.Java9Cleaner;
import net.daporkchop.lib.unsafe.cleaner.SunCleaner;

public abstract class PCleaner {
    private static final BiFunction<Object, Runnable, PCleaner> CLEANER_PROVIDER;

    public static PCleaner cleaner(@NonNull Object o, @NonNull Runnable cleaner) {
        if (o == null) {
            throw new NullPointerException("o");
        }
        if (cleaner == null) {
            throw new NullPointerException("cleaner");
        }
        return CLEANER_PROVIDER.apply(o, cleaner);
    }

    public static PCleaner cleaner(@NonNull Object o, long addr) {
        if (o == null) {
            throw new NullPointerException("o");
        }
        return CLEANER_PROVIDER.apply(o, () -> PUnsafe.freeMemory(addr));
    }

    public static PCleaner cleaner(@NonNull Object o, @NonNull AtomicLong addrRef) {
        if (o == null) {
            throw new NullPointerException("o");
        }
        if (addrRef == null) {
            throw new NullPointerException("addrRef");
        }
        return CLEANER_PROVIDER.apply(o, () -> {
            long addr = addrRef.getAndSet(-1L);
            if (addr > 0L) {
                PUnsafe.freeMemory(addr);
            }
        });
    }

    public abstract boolean clean();

    public abstract boolean hasRun();

    static {
        int[] version = Arrays.stream(System.getProperty("java.specification.version", "1.6").split("\\.")).mapToInt(Integer::parseInt).toArray();
        int javaVersion = version[0] == 1 ? version[1] : version[0];
        CLEANER_PROVIDER = javaVersion <= 8 ? SunCleaner::new : Java9Cleaner::new;
    }
}

