/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.random.wrapper;

import java.util.Random;
import lombok.NonNull;
import net.daporkchop.lib.common.util.PValidation;
import net.daporkchop.lib.random.PRandom;

public final class JavaRandomWrapper
implements PRandom {
    @NonNull
    private final Random delegate;

    @Override
    public Random asJava() {
        return this.delegate;
    }

    @Override
    public boolean nextBoolean() {
        return this.delegate.nextBoolean();
    }

    @Override
    public byte nextByte() {
        return (byte)(this.delegate.nextInt() & 0xFF);
    }

    @Override
    public void nextBytes(@NonNull byte[] dst) {
        if (dst == null) {
            throw new NullPointerException("dst");
        }
        this.delegate.nextBytes(dst);
    }

    @Override
    public void nextBytes(@NonNull byte[] dst, int start, int length) {
        if (dst == null) {
            throw new NullPointerException("dst");
        }
        PValidation.checkRangeLen(dst.length, start, length);
        if (start == 0 && length == dst.length) {
            this.delegate.nextBytes(dst);
            return;
        }
        int i = start;
        while (i < length) {
            long rnd = this.delegate.nextLong();
            long n = Math.min(length - i, 8);
            while (n-- > 0L) {
                dst[i++] = (byte)rnd;
                rnd >>= 8;
            }
        }
    }

    @Override
    public short nextShort() {
        return (short)(this.delegate.nextInt() & 0xFFFF);
    }

    @Override
    public int next(int bits) {
        return this.delegate.nextInt(1 << bits);
    }

    @Override
    public int nextInt() {
        return this.delegate.nextInt();
    }

    @Override
    public int nextUnsignedInt() {
        return this.delegate.nextInt() >>> 1;
    }

    @Override
    public int nextInt(int bound) {
        return this.delegate.nextInt(bound);
    }

    @Override
    public int nextInt(int origin, int bound) {
        return this.delegate.nextInt(bound - origin) + origin;
    }

    @Override
    public long next(long bits) {
        return this.delegate.nextLong() & (1L << (int)bits) - 1L;
    }

    @Override
    public long nextLong() {
        return this.delegate.nextLong();
    }

    @Override
    public long nextUnsignedLong() {
        return this.delegate.nextLong() >>> 1;
    }

    @Override
    public long nextLong(long bound) {
        if (bound <= 0L) {
            throw new IllegalArgumentException("bound must be positive");
        }
        long r = this.delegate.nextLong() >>> 1;
        long m4 = bound - 1L;
        if ((bound & m4) == 0L) {
            r &= m4;
        } else {
            long u = r;
            while (u - (r = u % bound) + m4 < 0L) {
                u = this.delegate.nextLong() >>> 1;
            }
        }
        return r;
    }

    @Override
    public long nextLong(int origin, int bound) {
        if (bound <= origin) {
            throw new IllegalArgumentException("max must be greater than min");
        }
        return this.nextLong(bound - origin) + (long)origin;
    }

    @Override
    public float nextFloat() {
        return this.delegate.nextFloat();
    }

    @Override
    public float nextFloat(float bound) {
        if (bound <= 0.0f) {
            throw new IllegalArgumentException("bound must be positive");
        }
        float result = this.delegate.nextFloat() * bound;
        return result < bound ? result : Float.intBitsToFloat(Float.floatToIntBits(bound) - 1);
    }

    @Override
    public float nextFloat(float origin, float bound) {
        if (bound <= origin) {
            throw new IllegalArgumentException("max must be greater than min");
        }
        return this.delegate.nextFloat() * (bound - origin) + origin;
    }

    @Override
    public float nextGaussianFloat() {
        return (float)this.delegate.nextGaussian();
    }

    @Override
    public double nextDouble() {
        return this.delegate.nextDouble();
    }

    @Override
    public double nextDouble(double bound) {
        if (bound <= 0.0) {
            throw new IllegalArgumentException("bound must be positive");
        }
        double result = this.delegate.nextDouble() * bound;
        return result < bound ? result : Double.longBitsToDouble(Double.doubleToLongBits(bound) - 1L);
    }

    @Override
    public double nextDouble(double origin, double bound) {
        if (bound <= origin) {
            throw new IllegalArgumentException("max must be greater than min");
        }
        return this.delegate.nextDouble() * (bound - origin) + origin;
    }

    @Override
    public double nextGaussianDouble() {
        return this.delegate.nextGaussian();
    }

    public JavaRandomWrapper(@NonNull Random delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate");
        }
        this.delegate = delegate;
    }

    @NonNull
    public Random delegate() {
        return this.delegate;
    }
}

