/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.random.impl;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import lombok.NonNull;
import net.daporkchop.lib.random.impl.AbstractFastPRandom;
import net.daporkchop.lib.unsafe.PUnsafe;

public final class ThreadLocalPRandom
extends AbstractFastPRandom {
    private static final long SEED = PUnsafe.pork_getOffset(Thread.class, "threadLocalRandomSeed");
    private static final long GAMMA = -7046029254386353131L;
    private static final ThreadLocalPRandom INSTANCE = new ThreadLocalPRandom();

    public static ThreadLocalPRandom current() {
        ThreadLocalRandom.current();
        return INSTANCE;
    }

    private static long mix64(long z) {
        z = (z ^ z >>> 33) * -49064778989728563L;
        z = (z ^ z >>> 33) * -4265267296055464877L;
        return z ^ z >>> 33;
    }

    private static int mix32(long z) {
        z = (z ^ z >>> 33) * -49064778989728563L;
        return (int)((z ^ z >>> 33) * -4265267296055464877L >>> 32);
    }

    private static long nextSeed() {
        Thread t2 = Thread.currentThread();
        long r = PUnsafe.getLong(t2, SEED) + -7046029254386353131L;
        PUnsafe.putLong(t2, SEED, r);
        return r;
    }

    @Override
    public Random asJava() {
        return ThreadLocalRandom.current();
    }

    @Override
    public void setSeed(long seed) {
        if (INSTANCE != null) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public boolean nextBoolean() {
        return ThreadLocalPRandom.mix32(ThreadLocalPRandom.nextSeed()) < 0;
    }

    @Override
    public byte nextByte() {
        return (byte)(ThreadLocalPRandom.mix32(ThreadLocalPRandom.nextSeed()) & 0xFF);
    }

    @Override
    public void nextBytes(@NonNull byte[] dst) {
        if (dst == null) {
            throw new NullPointerException("dst");
        }
        ThreadLocalRandom.current().nextBytes(dst);
    }

    @Override
    public void nextBytes(@NonNull byte[] dst, int start, int length) {
        if (dst == null) {
            throw new NullPointerException("dst");
        }
        if (start == 0 && length == dst.length) {
            ThreadLocalRandom.current().nextBytes(dst);
        } else {
            super.nextBytes(dst, start, length);
        }
    }

    @Override
    public short nextShort() {
        return (short)(ThreadLocalPRandom.mix32(ThreadLocalPRandom.nextSeed()) & 0xFFFF);
    }

    @Override
    public int next(int bits) {
        return ThreadLocalPRandom.mix32(ThreadLocalPRandom.nextSeed()) >>> (bits ^ 0x1F);
    }

    @Override
    public int nextInt() {
        return ThreadLocalPRandom.mix32(ThreadLocalPRandom.nextSeed());
    }

    @Override
    public int nextUnsignedInt() {
        return ThreadLocalPRandom.mix32(ThreadLocalPRandom.nextSeed()) >>> 1;
    }

    @Override
    public int nextInt(int bound) {
        if (bound <= 0) {
            throw new IllegalArgumentException("bound must be positive");
        }
        int r = ThreadLocalPRandom.mix32(ThreadLocalPRandom.nextSeed());
        int m4 = bound - 1;
        if ((bound & m4) == 0) {
            r &= m4;
        } else {
            int u = r >>> 1;
            while (u + m4 - (r = u % bound) < 0) {
                u = ThreadLocalPRandom.mix32(ThreadLocalPRandom.nextSeed()) >>> 1;
            }
        }
        return r;
    }

    @Override
    public int nextInt(int origin, int bound) {
        if (bound <= origin) {
            throw new IllegalArgumentException("max must be greater than min");
        }
        int r = ThreadLocalPRandom.mix32(ThreadLocalPRandom.nextSeed());
        int n = bound - origin;
        int m4 = n - 1;
        if ((n & m4) == 0) {
            r = (r & m4) + origin;
        } else if (n > 0) {
            int u = r >>> 1;
            while (u + m4 - (r = u % n) < 0) {
                u = ThreadLocalPRandom.mix32(ThreadLocalPRandom.nextSeed()) >>> 1;
            }
            r += origin;
        } else {
            while (r < origin || r >= bound) {
                r = ThreadLocalPRandom.mix32(ThreadLocalPRandom.nextSeed());
            }
        }
        return r;
    }

    @Override
    public long next(long bits) {
        return ThreadLocalPRandom.mix64(ThreadLocalPRandom.nextSeed()) >>> (int)(bits ^ 0x3FL);
    }

    @Override
    public long nextLong() {
        return ThreadLocalPRandom.mix64(ThreadLocalPRandom.nextSeed());
    }

    @Override
    public long nextUnsignedLong() {
        return ThreadLocalPRandom.mix64(ThreadLocalPRandom.nextSeed()) >>> 1;
    }

    @Override
    public long nextLong(long bound) {
        if (bound <= 0L) {
            throw new IllegalArgumentException("bound must be positive");
        }
        long r = ThreadLocalPRandom.mix64(ThreadLocalPRandom.nextSeed());
        long m4 = bound - 1L;
        if ((bound & m4) == 0L) {
            r &= m4;
        } else {
            long u = r >>> 1;
            while (u + m4 - (r = u % bound) < 0L) {
                u = ThreadLocalPRandom.mix64(ThreadLocalPRandom.nextSeed()) >>> 1;
            }
        }
        return r;
    }

    @Override
    public long nextLong(int origin, int bound) {
        if (bound <= origin) {
            throw new IllegalArgumentException("max must be greater than min");
        }
        long r = ThreadLocalPRandom.mix64(ThreadLocalPRandom.nextSeed());
        long n = bound - origin;
        long m4 = n - 1L;
        if ((n & m4) == 0L) {
            r = (r & m4) + (long)origin;
        } else if (n > 0L) {
            long u = r >>> 1;
            while (u + m4 - (r = u % n) < 0L) {
                u = ThreadLocalPRandom.mix64(ThreadLocalPRandom.nextSeed()) >>> 1;
            }
            r += (long)origin;
        } else {
            while (r < (long)origin || r >= (long)bound) {
                r = ThreadLocalPRandom.mix64(ThreadLocalPRandom.nextSeed());
            }
        }
        return r;
    }

    @Override
    public float nextFloat() {
        return (float)(ThreadLocalPRandom.mix32(ThreadLocalPRandom.nextSeed()) >>> 8) * 5.9604645E-8f;
    }

    @Override
    public float nextFloat(float bound) {
        if (bound <= 0.0f) {
            throw new IllegalArgumentException("bound must be positive");
        }
        float result = (float)(ThreadLocalPRandom.mix32(ThreadLocalPRandom.nextSeed()) >>> 8) * 5.9604645E-8f * bound;
        return result < bound ? result : Float.intBitsToFloat(Float.floatToIntBits(bound) - 1);
    }

    @Override
    public float nextFloat(float origin, float bound) {
        if (bound <= origin) {
            throw new IllegalArgumentException("max must be greater than min");
        }
        float result = (float)(ThreadLocalPRandom.mix32(ThreadLocalPRandom.nextSeed()) >>> 8) * 5.9604645E-8f * (bound - origin) + origin;
        return result < bound ? result : Float.intBitsToFloat(Float.floatToIntBits(bound) - 1);
    }

    @Override
    public float nextGaussianFloat() {
        return (float)ThreadLocalRandom.current().nextGaussian();
    }

    @Override
    public double nextDouble() {
        return (double)(ThreadLocalPRandom.mix64(ThreadLocalPRandom.nextSeed()) >>> 11) * (double)1.110223E-16f;
    }

    @Override
    public double nextDouble(double bound) {
        if (bound <= 0.0) {
            throw new IllegalArgumentException("bound must be positive");
        }
        double result = (double)(ThreadLocalPRandom.mix64(ThreadLocalPRandom.nextSeed()) >>> 11) * (double)1.110223E-16f * bound;
        return result < bound ? result : Double.longBitsToDouble(Double.doubleToLongBits(bound) - 1L);
    }

    @Override
    public double nextDouble(double origin, double bound) {
        if (bound <= origin) {
            throw new IllegalArgumentException("max must be greater than min");
        }
        double result = (double)(ThreadLocalPRandom.mix64(ThreadLocalPRandom.nextSeed()) >>> 11) * (double)1.110223E-16f * (bound - origin) + origin;
        return result < bound ? result : Double.longBitsToDouble(Double.doubleToLongBits(bound) - 1L);
    }

    @Override
    public double nextGaussianDouble() {
        return ThreadLocalRandom.current().nextGaussian();
    }

    @Override
    public double nextGaussian() {
        return ThreadLocalRandom.current().nextGaussian();
    }

    @Override
    public IntStream ints(long streamSize) {
        return ThreadLocalRandom.current().ints(streamSize);
    }

    @Override
    public IntStream ints() {
        return ThreadLocalRandom.current().ints();
    }

    @Override
    public IntStream ints(long streamSize, int randomNumberMin, int randomNumberBound) {
        return ThreadLocalRandom.current().ints(streamSize, randomNumberMin, randomNumberBound);
    }

    @Override
    public IntStream ints(int randomNumberMin, int randomNumberBound) {
        return ThreadLocalRandom.current().ints(randomNumberMin, randomNumberBound);
    }

    @Override
    public LongStream longs(long streamSize) {
        return ThreadLocalRandom.current().longs(streamSize);
    }

    @Override
    public LongStream longs() {
        return ThreadLocalRandom.current().longs();
    }

    @Override
    public LongStream longs(long streamSize, long randomNumberMin, long randomNumberBound) {
        return ThreadLocalRandom.current().longs(streamSize, randomNumberMin, randomNumberBound);
    }

    @Override
    public LongStream longs(long randomNumberMin, long randomNumberBound) {
        return ThreadLocalRandom.current().longs(randomNumberMin, randomNumberBound);
    }

    @Override
    public DoubleStream doubles(long streamSize) {
        return ThreadLocalRandom.current().doubles(streamSize);
    }

    @Override
    public DoubleStream doubles() {
        return ThreadLocalRandom.current().doubles();
    }

    @Override
    public DoubleStream doubles(long streamSize, double randomNumberMin, double randomNumberBound) {
        return ThreadLocalRandom.current().doubles(streamSize, randomNumberMin, randomNumberBound);
    }

    @Override
    public DoubleStream doubles(double randomNumberMin, double randomNumberBound) {
        return ThreadLocalRandom.current().doubles(randomNumberMin, randomNumberBound);
    }

    private ThreadLocalPRandom() {
    }
}

