/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.random.impl;

import java.util.concurrent.atomic.AtomicLong;
import net.daporkchop.lib.random.impl.AbstractFastPRandom;

public final class FastJavaPRandom
extends AbstractFastPRandom {
    private static final long multiplier = 25214903917L;
    private static final long addend = 11L;
    private static final long mask = 0xFFFFFFFFFFFFL;
    private static final AtomicLong seedUniquifier = new AtomicLong(8682522807148012L);
    private long seed;

    private static long initialScramble(long seed) {
        return (seed ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
    }

    public FastJavaPRandom() {
        this(seedUniquifier.updateAndGet(val -> val * 181783497276652981L) ^ System.nanoTime());
    }

    public FastJavaPRandom(long seed) {
        this.seed = FastJavaPRandom.initialScramble(seed);
    }

    @Override
    public int nextInt() {
        this.seed = this.seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (int)this.seed;
    }

    @Override
    public int next(int bits) {
        this.seed = this.seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (int)(this.seed >>> (int)(48L - (long)bits));
    }

    @Override
    public long nextLong() {
        return (long)this.nextInt() << 32 | (long)this.nextInt();
    }

    @Override
    public long next(long bits) {
        if (bits <= 32L) {
            this.seed = this.seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
            return this.seed >>> (int)(48L - bits);
        }
        return this.nextLong() >>> (int)(bits ^ 0x3FL);
    }

    @Override
    public void setSeed(long seed) {
        this.seed = FastJavaPRandom.initialScramble(seed);
    }
}

