/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.random.impl;

import java.util.Random;
import lombok.NonNull;
import net.daporkchop.lib.common.system.PlatformInfo;
import net.daporkchop.lib.common.util.PValidation;
import net.daporkchop.lib.random.PRandom;
import net.daporkchop.lib.unsafe.PUnsafe;

public abstract class AbstractFastPRandom
extends Random
implements PRandom {
    protected static final double DOUBLE_UNIT = (double)1.110223E-16f;
    protected static final float FLOAT_UNIT = 5.9604645E-8f;
    protected double nextGaussian = Double.NaN;

    @Override
    public abstract int nextInt();

    @Override
    public abstract long nextLong();

    @Override
    public Random asJava() {
        return this;
    }

    @Override
    public boolean nextBoolean() {
        return this.nextInt() < 0;
    }

    @Override
    public byte nextByte() {
        return (byte)(this.nextInt() & 0xFF);
    }

    @Override
    public void nextBytes(@NonNull byte[] dst) {
        if (dst == null) {
            throw new NullPointerException("dst");
        }
        this.nextBytes(dst, 0, dst.length);
    }

    @Override
    public void nextBytes(@NonNull byte[] dst, int start, int length) {
        if (dst == null) {
            throw new NullPointerException("dst");
        }
        PValidation.checkRangeLen(dst.length, start, length);
        if (length == 0) {
            return;
        }
        if (PlatformInfo.IS_64BIT) {
            if (PlatformInfo.IS_LITTLE_ENDIAN && length >= 16) {
                this.nextBytes64Fast(dst, start, length);
            } else {
                this.nextBytes64(dst, start, length);
            }
        } else if (PlatformInfo.IS_32BIT) {
            if (PlatformInfo.IS_LITTLE_ENDIAN && length >= 8) {
                this.nextBytes32Fast(dst, start, length);
            } else {
                this.nextBytes32(dst, start, length);
            }
        } else {
            this.nextBytes32(dst, start, length);
        }
    }

    protected final void nextBytes64Fast(byte[] dst, int start, int length) {
        long i = PUnsafe.ARRAY_BYTE_BASE_OFFSET + (long)start;
        long end = PUnsafe.ARRAY_BYTE_BASE_OFFSET + (long)start + (long)length;
        if (!PlatformInfo.UNALIGNED && (i & 7L) != 0L) {
            long val = this.nextLong();
            length = (int)((long)length - (i & 7L));
            do {
                PUnsafe.putByte(dst, i++, (byte)val);
                val >>>= 8;
            } while (i < end && (i & 7L) != 0L);
        }
        for (int words = length >>> 3; words > 0; --words) {
            PUnsafe.putLong(dst, i, this.nextLong());
            i += 8L;
        }
        int bytes = length & 7;
        if (bytes != 0) {
            long val = this.nextLong();
            do {
                PUnsafe.putByte(dst, i++, (byte)val);
                val >>>= 8;
            } while (i < end);
        }
    }

    protected final void nextBytes64(byte[] dst, int start, int length) {
        int i = start;
        while (i < length) {
            int n = Math.min(length - i, 8);
            long rnd = this.nextLong();
            while (n-- > 0) {
                dst[i++] = (byte)rnd;
                rnd >>>= 8;
                --n;
            }
        }
    }

    protected final void nextBytes32Fast(byte[] dst, int start, int length) {
        long i = PUnsafe.ARRAY_BYTE_BASE_OFFSET + (long)start;
        long end = PUnsafe.ARRAY_BYTE_BASE_OFFSET + (long)start + (long)length;
        if (!PlatformInfo.UNALIGNED && (i & 3L) != 0L) {
            length = (int)((long)length - (i & 3L));
            int val = this.nextInt();
            do {
                PUnsafe.putByte(dst, i++, (byte)val);
                val >>>= 8;
            } while (i < end && (i & 3L) != 0L);
        }
        for (int words = length >>> 2; words > 0; --words) {
            PUnsafe.putInt(dst, i, this.nextInt());
            i += 4L;
        }
        int bytes = length & 3;
        if (bytes != 0) {
            int val = this.nextInt();
            do {
                PUnsafe.putByte(dst, i++, (byte)val);
                val >>>= 8;
            } while (i < end);
        }
    }

    protected final void nextBytes32(byte[] dst, int start, int length) {
        int i = start;
        while (i < length) {
            int n = Math.min(length - i, 4);
            int rnd = this.nextInt();
            while (n-- > 0) {
                dst[i++] = (byte)rnd;
                rnd >>>= 8;
                --n;
            }
        }
    }

    @Override
    public short nextShort() {
        return (short)(this.nextInt() & 0xFFFF);
    }

    @Override
    public int next(int bits) {
        return this.nextInt() >>> (bits ^ 0x1F);
    }

    @Override
    public int nextUnsignedInt() {
        return this.nextInt() >>> 1;
    }

    @Override
    public int nextInt(int bound) {
        if (bound <= 0) {
            throw new IllegalArgumentException("bound must be positive");
        }
        int r = this.nextInt();
        int m4 = bound - 1;
        if ((bound & m4) == 0) {
            r &= m4;
        } else {
            int u = r >>> 1;
            while (u + m4 - (r = u % bound) < 0) {
                u = this.nextInt() >>> 1;
            }
        }
        return r;
    }

    @Override
    public int nextInt(int origin, int bound) {
        if (bound <= origin) {
            throw new IllegalArgumentException("max must be greater than min");
        }
        int r = this.nextInt();
        int n = bound - origin;
        int m4 = n - 1;
        if ((n & m4) == 0) {
            r = (r & m4) + origin;
        } else if (n > 0) {
            int u = r >>> 1;
            while (u + m4 - (r = u % n) < 0) {
                u = this.nextInt() >>> 1;
            }
            r += origin;
        } else {
            while (r < origin || r >= bound) {
                r = this.nextInt();
            }
        }
        return r;
    }

    @Override
    public long next(long bits) {
        return this.nextLong() >>> (int)(bits ^ 0x3FL);
    }

    @Override
    public long nextUnsignedLong() {
        return this.nextLong() >>> 1;
    }

    @Override
    public long nextLong(long bound) {
        if (bound <= 0L) {
            throw new IllegalArgumentException("bound must be positive");
        }
        long r = this.nextLong();
        long m4 = bound - 1L;
        if ((bound & m4) == 0L) {
            r &= m4;
        } else {
            long u = r >>> 1;
            while (u + m4 - (r = u % bound) < 0L) {
                u = this.nextLong() >>> 1;
            }
        }
        return r;
    }

    @Override
    public long nextLong(int origin, int bound) {
        if (bound <= origin) {
            throw new IllegalArgumentException("max must be greater than min");
        }
        long r = this.nextLong();
        long n = bound - origin;
        long m4 = n - 1L;
        if ((n & m4) == 0L) {
            r = (r & m4) + (long)origin;
        } else if (n > 0L) {
            long u = r >>> 1;
            while (u + m4 - (r = u % n) < 0L) {
                u = this.nextLong() >>> 1;
            }
            r += (long)origin;
        } else {
            while (r < (long)origin || r >= (long)bound) {
                r = this.nextLong();
            }
        }
        return r;
    }

    @Override
    public float nextFloat() {
        return (float)(this.nextInt() >>> 8) * 5.9604645E-8f;
    }

    @Override
    public float nextFloat(float bound) {
        if (bound <= 0.0f) {
            throw new IllegalArgumentException("bound must be positive");
        }
        float result = (float)(this.nextInt() >>> 8) * 5.9604645E-8f * bound;
        return result < bound ? result : Float.intBitsToFloat(Float.floatToIntBits(bound) - 1);
    }

    @Override
    public float nextFloat(float origin, float bound) {
        if (bound <= origin) {
            throw new IllegalArgumentException("max must be greater than min");
        }
        float result = (float)(this.nextInt() >>> 8) * 5.9604645E-8f * (bound - origin) + origin;
        return result < bound ? result : Float.intBitsToFloat(Float.floatToIntBits(bound) - 1);
    }

    @Override
    public float nextGaussianFloat() {
        return (float)this.nextGaussian();
    }

    @Override
    public double nextDouble() {
        return (double)(this.nextLong() >>> 11) * (double)1.110223E-16f;
    }

    @Override
    public double nextDouble(double bound) {
        if (bound <= 0.0) {
            throw new IllegalArgumentException("bound must be positive");
        }
        double result = (double)(this.nextLong() >>> 11) * (double)1.110223E-16f * bound;
        return result < bound ? result : Double.longBitsToDouble(Double.doubleToLongBits(bound) - 1L);
    }

    @Override
    public double nextDouble(double origin, double bound) {
        if (bound <= origin) {
            throw new IllegalArgumentException("max must be greater than min");
        }
        double result = (double)(this.nextLong() >>> 11) * (double)1.110223E-16f * (bound - origin) + origin;
        return result < bound ? result : Double.longBitsToDouble(Double.doubleToLongBits(bound) - 1L);
    }

    @Override
    public double nextGaussianDouble() {
        double v2;
        double v1;
        double s2;
        double nextGaussianDouble = this.nextGaussian;
        if (!Double.isNaN(nextGaussianDouble)) {
            this.nextGaussian = Double.NaN;
            return nextGaussianDouble;
        }
        while ((s2 = (v1 = 2.0 * this.nextDouble() - 1.0) * v1 + (v2 = 2.0 * this.nextDouble() - 1.0) * v2) >= 1.0 || s2 == 0.0) {
        }
        double multiplier = StrictMath.sqrt(-2.0 * StrictMath.log(s2) / s2);
        this.nextGaussian = v2 * multiplier;
        return v1 * multiplier;
    }

    @Override
    public double nextGaussian() {
        return this.nextGaussianDouble();
    }
}

