/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.random;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import lombok.NonNull;
import net.daporkchop.lib.common.util.PArrays;
import net.daporkchop.lib.common.util.PValidation;
import net.daporkchop.lib.random.impl.AbstractFastPRandom;
import net.daporkchop.lib.random.impl.ThreadLocalPRandom;
import net.daporkchop.lib.random.wrapper.JavaRandomWrapper;
import net.daporkchop.lib.random.wrapper.PRandomWrapper;

public interface PRandom {
    public static PRandom wrap(@NonNull Random random) {
        if (random == null) {
            throw new NullPointerException("random");
        }
        if (random instanceof PRandomWrapper) {
            return ((PRandomWrapper)random).delegate();
        }
        if (random instanceof ThreadLocalRandom) {
            return ThreadLocalPRandom.current();
        }
        if (random instanceof AbstractFastPRandom) {
            return (AbstractFastPRandom)random;
        }
        return new JavaRandomWrapper(random);
    }

    public Random asJava();

    public boolean nextBoolean();

    public byte nextByte();

    default public void nextBytes(@NonNull byte[] dst) {
        if (dst == null) {
            throw new NullPointerException("dst");
        }
        this.nextBytes(dst, 0, dst.length);
    }

    public void nextBytes(@NonNull byte[] var1, int var2, int var3);

    public short nextShort();

    public int next(int var1);

    public int nextInt();

    public int nextUnsignedInt();

    public int nextInt(int var1);

    public int nextInt(int var1, int var2);

    public long next(long var1);

    public long nextLong();

    public long nextUnsignedLong();

    public long nextLong(long var1);

    public long nextLong(int var1, int var2);

    public float nextFloat();

    public float nextFloat(float var1);

    public float nextFloat(float var1, float var2);

    public float nextGaussianFloat();

    public double nextDouble();

    public double nextDouble(double var1);

    public double nextDouble(double var1, double var3);

    public double nextGaussianDouble();

    default public byte[] shuffle(@NonNull byte[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        return this.shuffle(arr, 0, arr.length);
    }

    default public byte[] shuffle(@NonNull byte[] arr, int start, int length) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        PValidation.checkRangeLen(arr.length, start, length);
        int end = start + length;
        for (int i = start; i < end; ++i) {
            PArrays.swap(arr, i, this.nextInt(start, length));
        }
        return arr;
    }

    default public short[] shuffle(@NonNull short[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        return this.shuffle(arr, 0, arr.length);
    }

    default public short[] shuffle(@NonNull short[] arr, int start, int length) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        PValidation.checkRangeLen(arr.length, start, length);
        int end = start + length;
        for (int i = start; i < end; ++i) {
            PArrays.swap(arr, i, this.nextInt(start, length));
        }
        return arr;
    }

    default public char[] shuffle(@NonNull char[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        return this.shuffle(arr, 0, arr.length);
    }

    default public char[] shuffle(@NonNull char[] arr, int start, int length) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        PValidation.checkRangeLen(arr.length, start, length);
        int end = start + length;
        for (int i = start; i < end; ++i) {
            PArrays.swap(arr, i, this.nextInt(start, length));
        }
        return arr;
    }

    default public int[] shuffle(@NonNull int[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        return this.shuffle(arr, 0, arr.length);
    }

    default public int[] shuffle(@NonNull int[] arr, int start, int length) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        PValidation.checkRangeLen(arr.length, start, length);
        int end = start + length;
        for (int i = start; i < end; ++i) {
            PArrays.swap(arr, i, this.nextInt(start, length));
        }
        return arr;
    }

    default public long[] shuffle(@NonNull long[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        return this.shuffle(arr, 0, arr.length);
    }

    default public long[] shuffle(@NonNull long[] arr, int start, int length) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        PValidation.checkRangeLen(arr.length, start, length);
        int end = start + length;
        for (int i = start; i < end; ++i) {
            PArrays.swap(arr, i, this.nextInt(start, length));
        }
        return arr;
    }

    default public float[] shuffle(@NonNull float[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        return this.shuffle(arr, 0, arr.length);
    }

    default public float[] shuffle(@NonNull float[] arr, int start, int length) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        PValidation.checkRangeLen(arr.length, start, length);
        int end = start + length;
        for (int i = start; i < end; ++i) {
            PArrays.swap(arr, i, this.nextInt(start, length));
        }
        return arr;
    }

    default public double[] shuffle(@NonNull double[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        return this.shuffle(arr, 0, arr.length);
    }

    default public double[] shuffle(@NonNull double[] arr, int start, int length) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        PValidation.checkRangeLen(arr.length, start, length);
        int end = start + length;
        for (int i = start; i < end; ++i) {
            PArrays.swap(arr, i, this.nextInt(start, length));
        }
        return arr;
    }

    default public <T> T[] shuffle(@NonNull T[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        return this.shuffle(arr, 0, arr.length);
    }

    default public <T> T[] shuffle(@NonNull T[] arr, int start, int length) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        PValidation.checkRangeLen(arr.length, start, length);
        int end = start + length;
        for (int i = start; i < end; ++i) {
            PArrays.swap(arr, i, this.nextInt(start, length));
        }
        return arr;
    }
}

