/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.noise.filter.range;

import lombok.NonNull;
import net.daporkchop.lib.noise.NoiseSource;
import net.daporkchop.lib.noise.filter.FilterNoiseSource;
import net.daporkchop.lib.noise.util.NoiseFactory;
import net.daporkchop.lib.random.PRandom;

public final class RangeConversionFilter
extends FilterNoiseSource {
    private final double fromMin;
    private final double factor;
    private final double min;
    private final double max;

    public RangeConversionFilter(@NonNull NoiseSource delegate, double min2, double max) {
        super(delegate);
        if (delegate == null) {
            throw new NullPointerException("delegate");
        }
        this.fromMin = delegate.min();
        this.factor = (max - min2) / (delegate.max() - this.fromMin);
        this.min = min2;
        this.max = max;
    }

    public RangeConversionFilter(@NonNull NoiseFactory factory, @NonNull PRandom random, double min2, double max) {
        this(factory.apply(random), min2, max);
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        if (random == null) {
            throw new NullPointerException("random");
        }
    }

    @Override
    public double get(double x) {
        return (this.delegate.get(x) - this.fromMin) * this.factor + this.min;
    }

    @Override
    public double get(double x, double y) {
        return (this.delegate.get(x, y) - this.fromMin) * this.factor + this.min;
    }

    @Override
    public double get(double x, double y, double z) {
        return (this.delegate.get(x, y, z) - this.fromMin) * this.factor + this.min;
    }

    @Override
    public String toString() {
        return String.format("Range(%s,min=%f,max=%f)", this.delegate, this.min, this.max);
    }

    public double fromMin() {
        return this.fromMin;
    }

    public double factor() {
        return this.factor;
    }

    @Override
    public double min() {
        return this.min;
    }

    @Override
    public double max() {
        return this.max;
    }
}

