/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.noise.filter.math;

import lombok.NonNull;
import net.daporkchop.lib.noise.NoiseSource;

public final class SourceAddFilter
implements NoiseSource {
    private final double min;
    private final double max;
    private final NoiseSource a;
    private final NoiseSource b;

    public SourceAddFilter(@NonNull NoiseSource a, @NonNull NoiseSource b) {
        if (a == null) {
            throw new NullPointerException("a");
        }
        if (b == null) {
            throw new NullPointerException("b");
        }
        this.a = a;
        this.b = b;
        this.min = a.min() + b.min();
        this.max = a.max() + b.max();
    }

    @Override
    public double get(double x) {
        return this.a.get(x) + this.b.get(x);
    }

    @Override
    public double get(double x, double y) {
        return this.a.get(x, y) + this.b.get(x, y);
    }

    @Override
    public double get(double x, double y, double z) {
        return this.a.get(x, y, z) + this.b.get(x, y, z);
    }

    public String toString() {
        return this.a + " + " + this.b;
    }

    @Override
    public double min() {
        return this.min;
    }

    @Override
    public double max() {
        return this.max;
    }
}

