/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.noise.filter.math;

import lombok.NonNull;
import net.daporkchop.lib.noise.NoiseSource;
import net.daporkchop.lib.noise.filter.FilterNoiseSource;
import net.daporkchop.lib.noise.util.NoiseFactory;
import net.daporkchop.lib.random.PRandom;

public final class ScalarMulFilter
extends FilterNoiseSource {
    private final double val;
    private final double min;
    private final double max;

    public ScalarMulFilter(@NonNull NoiseSource delegate, double val) {
        super(delegate);
        if (delegate == null) {
            throw new NullPointerException("delegate");
        }
        this.val = val;
        double min2 = delegate.min();
        double max = delegate.max();
        this.min = Math.min(min2 * val, max * val);
        this.max = Math.max(min2 * val, max * val);
    }

    public ScalarMulFilter(@NonNull NoiseFactory factory, @NonNull PRandom random, double val) {
        this(factory.apply(random), val);
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        if (random == null) {
            throw new NullPointerException("random");
        }
    }

    @Override
    public double get(double x) {
        return this.delegate.get(x) * this.val;
    }

    @Override
    public double get(double x, double y) {
        return this.delegate.get(x, y) * this.val;
    }

    @Override
    public double get(double x, double y, double z) {
        return this.delegate.get(x, y, z) * this.val;
    }

    @Override
    public String toString() {
        return String.format("%s * %f", this.delegate, this.val);
    }

    @Override
    public double min() {
        return this.min;
    }

    @Override
    public double max() {
        return this.max;
    }
}

