/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.noise.filter.math;

import lombok.NonNull;
import net.daporkchop.lib.noise.NoiseSource;
import net.daporkchop.lib.noise.filter.FilterNoiseSource;
import net.daporkchop.lib.noise.util.NoiseFactory;
import net.daporkchop.lib.random.PRandom;

public final class ScalarAddFilter
extends FilterNoiseSource {
    private final double val;
    private final double min;
    private final double max;

    public ScalarAddFilter(@NonNull NoiseSource delegate, double val) {
        super(delegate);
        if (delegate == null) {
            throw new NullPointerException("delegate");
        }
        this.val = val;
        this.min = delegate.min() + val;
        this.max = delegate.max() + val;
    }

    public ScalarAddFilter(@NonNull NoiseFactory factory, @NonNull PRandom random, double val) {
        this(factory.apply(random), val);
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        if (random == null) {
            throw new NullPointerException("random");
        }
    }

    @Override
    public double get(double x) {
        return this.delegate.get(x) + this.val;
    }

    @Override
    public double get(double x, double y) {
        return this.delegate.get(x, y) + this.val;
    }

    @Override
    public double get(double x, double y, double z) {
        return this.delegate.get(x, y, z) + this.val;
    }

    @Override
    public String toString() {
        return String.format("%s + %f", this.delegate, this.val);
    }

    @Override
    public double min() {
        return this.min;
    }

    @Override
    public double max() {
        return this.max;
    }
}

