/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.noise.filter;

import lombok.NonNull;
import net.daporkchop.lib.common.math.PMath;
import net.daporkchop.lib.noise.NoiseSource;
import net.daporkchop.lib.noise.filter.FilterNoiseSource;
import net.daporkchop.lib.noise.util.NoiseFactory;
import net.daporkchop.lib.random.PRandom;

public final class WeightedFilter
extends FilterNoiseSource {
    private static double fade(double t2) {
        return PMath.clamp(t2 * t2 * (-t2 * 2.0 + 3.0), 0.0, 1.0);
    }

    public WeightedFilter(@NonNull NoiseSource delegate) {
        super(delegate.toRange(0.0, 1.0));
        if (delegate == null) {
            throw new NullPointerException("delegate");
        }
    }

    public WeightedFilter(@NonNull NoiseFactory factory, @NonNull PRandom random) {
        this(factory.apply(random));
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        if (random == null) {
            throw new NullPointerException("random");
        }
    }

    @Override
    public double min() {
        return 0.0;
    }

    @Override
    public double max() {
        return 1.0;
    }

    @Override
    public double get(double x) {
        return WeightedFilter.fade(this.delegate.get(x));
    }

    @Override
    public double get(double x, double y) {
        return WeightedFilter.fade(this.delegate.get(x, y));
    }

    @Override
    public double get(double x, double y, double z) {
        return WeightedFilter.fade(this.delegate.get(x, y, z));
    }

    @Override
    public String toString() {
        return String.format("Weighted(%s)", this.delegate);
    }
}

