/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.noise.filter;

import lombok.NonNull;
import net.daporkchop.lib.common.util.PValidation;
import net.daporkchop.lib.noise.NoiseSource;
import net.daporkchop.lib.noise.filter.FilterNoiseSource;
import net.daporkchop.lib.noise.util.NoiseFactory;
import net.daporkchop.lib.random.PRandom;

public final class ScaleOctavesOffsetFilter
extends FilterNoiseSource {
    private final double scaleX;
    private final double scaleY;
    private final double scaleZ;
    private final int octaves;
    private final double factor;
    private final double offset;
    private final double min;
    private final double max;

    public ScaleOctavesOffsetFilter(@NonNull NoiseSource delegate, double scaleX, double scaleY, double scaleZ, int octaves, double factor, double offset) {
        super(delegate);
        if (delegate == null) {
            throw new NullPointerException("delegate");
        }
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.scaleZ = scaleZ;
        this.octaves = PValidation.positive(octaves);
        this.factor = factor;
        this.offset = offset;
        double min2 = delegate.min();
        double max = delegate.max();
        double center = (min2 + max) / 2.0;
        double octaveDeviation = Math.abs(max - center);
        double theoreticalMaxDeviation = 0.0;
        for (int i = octaves - 1; i >= 0; --i) {
            theoreticalMaxDeviation += octaveDeviation;
            octaveDeviation *= 0.5;
        }
        min2 = center - theoreticalMaxDeviation;
        max = center + theoreticalMaxDeviation;
        this.min = Math.min(min2 * factor + offset, max * factor + offset);
        this.max = Math.max(min2 * factor + offset, max * factor + offset);
    }

    public ScaleOctavesOffsetFilter(@NonNull NoiseFactory factory, @NonNull PRandom random, double scaleX, double scaleY, double scaleZ, int octaves, double factor, double offset) {
        this(factory.apply(random), scaleX, scaleY, scaleZ, octaves, factor, offset);
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        if (random == null) {
            throw new NullPointerException("random");
        }
    }

    @Override
    public double get(double x) {
        x *= this.scaleX;
        double val = 0.0;
        double factor = 1.0;
        double scale = 1.0;
        for (int i = this.octaves - 1; i >= 0; --i) {
            val += this.delegate.get(x * scale) * factor;
            factor *= 0.5;
            scale *= 2.0;
        }
        return val * this.factor + this.offset;
    }

    @Override
    public double get(double x, double y) {
        x *= this.scaleX;
        y *= this.scaleY;
        double val = 0.0;
        double factor = 1.0;
        double scale = 1.0;
        for (int i = this.octaves - 1; i >= 0; --i) {
            val += this.delegate.get(x * scale, y * scale) * factor;
            factor *= 0.5;
            scale *= 2.0;
        }
        return val * this.factor + this.offset;
    }

    @Override
    public double get(double x, double y, double z) {
        x *= this.scaleX;
        y *= this.scaleY;
        z *= this.scaleZ;
        double val = 0.0;
        double factor = 1.0;
        double scale = 1.0;
        for (int i = this.octaves - 1; i >= 0; --i) {
            val += this.delegate.get(x * scale, y * scale, z * scale) * factor;
            factor *= 0.5;
            scale *= 2.0;
        }
        return val * this.factor + this.offset;
    }

    @Override
    public String toString() {
        return String.format("ScaleOctavesOffset(%s,scale=(%f,%f,%f),octaves=%d,factor=%f,offset=%f", this.delegate, this.scaleX, this.scaleY, this.scaleZ, this.octaves, this.factor, this.offset);
    }

    @Override
    public double min() {
        return this.min;
    }

    @Override
    public double max() {
        return this.max;
    }
}

