/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.noise.filter;

import lombok.NonNull;
import net.daporkchop.lib.noise.NoiseSource;
import net.daporkchop.lib.noise.filter.FilterNoiseSource;
import net.daporkchop.lib.noise.util.NoiseFactory;
import net.daporkchop.lib.random.PRandom;

public final class ScaleFilter
extends FilterNoiseSource {
    private final double scaleX;
    private final double scaleY;
    private final double scaleZ;

    public ScaleFilter(@NonNull NoiseSource delegate, double scaleX, double scaleY, double scaleZ) {
        super(delegate);
        if (delegate == null) {
            throw new NullPointerException("delegate");
        }
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.scaleZ = scaleZ;
    }

    public ScaleFilter(@NonNull NoiseFactory factory, @NonNull PRandom random, double scaleX, double scaleY, double scaleZ) {
        this(factory.apply(random), scaleX, scaleY, scaleZ);
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        if (random == null) {
            throw new NullPointerException("random");
        }
    }

    @Override
    public double min() {
        return this.delegate.min();
    }

    @Override
    public double max() {
        return this.delegate.max();
    }

    @Override
    public double get(double x) {
        return this.delegate.get(x * this.scaleX);
    }

    @Override
    public double get(double x, double y) {
        return this.delegate.get(x * this.scaleX, y * this.scaleY);
    }

    @Override
    public double get(double x, double y, double z) {
        return this.delegate.get(x * this.scaleX, y * this.scaleY, z * this.scaleZ);
    }

    @Override
    public String toString() {
        return String.format("Scale(%s,(%f,%f,%f))", this.delegate, this.scaleX, this.scaleY, this.scaleZ);
    }
}

