/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.noise.filter;

import lombok.NonNull;
import net.daporkchop.lib.common.util.PValidation;
import net.daporkchop.lib.noise.NoiseSource;
import net.daporkchop.lib.noise.filter.FilterNoiseSource;
import net.daporkchop.lib.noise.util.NoiseFactory;
import net.daporkchop.lib.random.PRandom;

public final class OctaveFilter
extends FilterNoiseSource {
    private final double min;
    private final double max;
    private final int octaves;

    public OctaveFilter(@NonNull NoiseSource delegate, int octaves) {
        super(delegate);
        if (delegate == null) {
            throw new NullPointerException("delegate");
        }
        this.octaves = PValidation.positive(octaves);
        double min2 = delegate.min();
        double max = delegate.max();
        double center = (min2 + max) / 2.0;
        double octaveDeviation = Math.abs(max - center);
        double theoreticalMaxDeviation = 0.0;
        for (int i = octaves - 1; i >= 0; --i) {
            theoreticalMaxDeviation += octaveDeviation;
            octaveDeviation *= 0.5;
        }
        this.min = center - theoreticalMaxDeviation;
        this.max = center + theoreticalMaxDeviation;
    }

    public OctaveFilter(@NonNull NoiseFactory factory, @NonNull PRandom random, int octaves) {
        this(factory.apply(random), octaves);
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        if (random == null) {
            throw new NullPointerException("random");
        }
    }

    @Override
    public double get(double x) {
        double val = 0.0;
        double factor = 1.0;
        double scale = 1.0;
        for (int i = this.octaves - 1; i >= 0; --i) {
            val += this.delegate.get(x * scale) * factor;
            factor *= 0.5;
            scale *= 2.0;
        }
        return val;
    }

    @Override
    public double get(double x, double y) {
        double val = 0.0;
        double factor = 1.0;
        double scale = 1.0;
        for (int i = this.octaves - 1; i >= 0; --i) {
            val += this.delegate.get(x * scale, y * scale) * factor;
            factor *= 0.5;
            scale *= 2.0;
        }
        return val;
    }

    @Override
    public double get(double x, double y, double z) {
        double val = 0.0;
        double factor = 1.0;
        double scale = 1.0;
        for (int i = this.octaves - 1; i >= 0; --i) {
            val += this.delegate.get(x * scale, y * scale, z * scale) * factor;
            factor *= 0.5;
            scale *= 2.0;
        }
        return val;
    }

    @Override
    public String toString() {
        return String.format("Octaves(%s,%d)", this.delegate, this.octaves);
    }

    @Override
    public double min() {
        return this.min;
    }

    @Override
    public double max() {
        return this.max;
    }
}

