/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.noise.filter;

import lombok.NonNull;
import net.daporkchop.lib.common.math.PMath;
import net.daporkchop.lib.noise.NoiseSource;

public final class LerpFilter
implements NoiseSource {
    private final double min;
    private final double max;
    private final NoiseSource a;
    private final NoiseSource b;
    private final NoiseSource t;

    public LerpFilter(@NonNull NoiseSource a, @NonNull NoiseSource b, @NonNull NoiseSource t2) {
        if (a == null) {
            throw new NullPointerException("a");
        }
        if (b == null) {
            throw new NullPointerException("b");
        }
        if (t2 == null) {
            throw new NullPointerException("t");
        }
        this.a = a;
        this.b = b;
        this.t = t2.toRange(0.0, 1.0);
        this.min = Math.min(this.a.min(), this.b.min());
        this.max = Math.max(this.a.max(), this.b.max());
    }

    @Override
    public double get(double x) {
        return PMath.lerp(this.a.get(x), this.b.get(x), this.t.get(x));
    }

    @Override
    public double get(double x, double y) {
        return PMath.lerp(this.a.get(x, y), this.b.get(x, y), this.t.get(x, y));
    }

    @Override
    public double get(double x, double y, double z) {
        return PMath.lerp(this.a.get(x, y, z), this.b.get(x, y, z), this.t.get(x, y, z));
    }

    public String toString() {
        return String.format("lerp(a=%s,b=%s,t=%s)", this.a, this.b, this.t);
    }

    @Override
    public double min() {
        return this.min;
    }

    @Override
    public double max() {
        return this.max;
    }
}

