/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.noise.engine;

import lombok.NonNull;
import net.daporkchop.lib.common.math.PMath;
import net.daporkchop.lib.noise.engine.PerlinNoiseEngine;
import net.daporkchop.lib.random.PRandom;

public class SimplexNoiseEngine
extends PerlinNoiseEngine {
    protected static final double STRETCH_CONSTANT_2D = 0.211324865405187;
    protected static final double SQUISH_CONSTANT_2D = 0.366025403784439;
    protected static final double STRETCH_CONSTANT_3D = 0.16666666666666666;
    protected static final double SQUISH_CONSTANT_3D = 0.3333333333333333;

    public SimplexNoiseEngine(@NonNull PRandom random) {
        super(random);
        if (random == null) {
            throw new NullPointerException("random");
        }
    }

    @Override
    public double get(double x) {
        int i0 = PMath.floorI(x);
        int i1 = i0 + 1;
        double x0 = x - (double)i0;
        double x1 = x0 - 1.0;
        double t0 = 1.0 - x0 * x0;
        t0 *= t0;
        double n0 = t0 * t0 * SimplexNoiseEngine.grad(this.p[i0 & 0xFF] & 0xFF, x0);
        double t1 = 1.0 - x1 * x1;
        t1 *= t1;
        double n1 = t1 * t1 * SimplexNoiseEngine.grad(this.p[i1 & 0xFF] & 0xFF, x1);
        return (n0 + n1) * 0.395;
    }

    @Override
    public double get(double x, double y) {
        double Y0;
        double y0;
        int j;
        double t2;
        double s2 = (x + y) * 0.366025403784439;
        double xs = x + s2;
        double ys = y + s2;
        int i = PMath.floorI(xs);
        double X0 = (double)i - (t2 = (double)(i + (j = PMath.floorI(ys))) * 0.211324865405187);
        double x0 = x - X0;
        int i1 = x0 > (y0 = y - (Y0 = (double)j - t2)) ? 1 : 0;
        int j1 = x0 > y0 ? 0 : 1;
        double x1 = x0 - (double)i1 + 0.211324865405187;
        double y1 = y0 - (double)j1 + 0.211324865405187;
        double x2 = x0 - 1.0 + 0.422649730810374;
        double y2 = y0 - 1.0 + 0.422649730810374;
        double n0 = 0.0;
        double t0 = 0.5 - x0 * x0 - y0 * y0;
        if (t0 >= 0.0) {
            t0 *= t0;
            n0 = t0 * t0 * SimplexNoiseEngine.grad(this.p[i + this.p[j & 0xFF] & 0xFF] & 0xFF, x0, y0);
        }
        double n1 = 0.0;
        double t1 = 0.5 - x1 * x1 - y1 * y1;
        if (t1 >= 0.0) {
            t1 *= t1;
            n1 = t1 * t1 * SimplexNoiseEngine.grad(this.p[i + i1 + this.p[j + j1 & 0xFF] & 0xFF] & 0xFF, x1, y1);
        }
        double n2 = 0.0;
        double t22 = 0.5 - x2 * x2 - y2 * y2;
        if (t22 >= 0.0) {
            t22 *= t22;
            n2 = t22 * t22 * SimplexNoiseEngine.grad(this.p[i + 1 + this.p[j + 1 & 0xFF] & 0xFF], x2, y2);
        }
        return (n0 + n1 + n2) * 40.0;
    }

    @Override
    public double get(double x, double y, double z) {
        int k2;
        int j2;
        int i2;
        int k1;
        int j1;
        int i1;
        double s2 = (x + y + z) * 0.3333333333333333;
        double xs = x + s2;
        double ys = y + s2;
        double zs = z + s2;
        int i = PMath.floorI(xs);
        int j = PMath.floorI(ys);
        int k = PMath.floorI(zs);
        double t2 = (double)(i + j + k) * 0.16666666666666666;
        double X0 = (double)i - t2;
        double Y0 = (double)j - t2;
        double Z0 = (double)k - t2;
        double x0 = x - X0;
        double y0 = y - Y0;
        double z0 = z - Z0;
        if (x0 >= y0) {
            if (y0 >= z0) {
                i1 = 1;
                j1 = 0;
                k1 = 0;
                i2 = 1;
                j2 = 1;
                k2 = 0;
            } else if (x0 >= z0) {
                i1 = 1;
                j1 = 0;
                k1 = 0;
                i2 = 1;
                j2 = 0;
                k2 = 1;
            } else {
                i1 = 0;
                j1 = 0;
                k1 = 1;
                i2 = 1;
                j2 = 0;
                k2 = 1;
            }
        } else if (y0 < z0) {
            i1 = 0;
            j1 = 0;
            k1 = 1;
            i2 = 0;
            j2 = 1;
            k2 = 1;
        } else if (x0 < z0) {
            i1 = 0;
            j1 = 1;
            k1 = 0;
            i2 = 0;
            j2 = 1;
            k2 = 1;
        } else {
            i1 = 0;
            j1 = 1;
            k1 = 0;
            i2 = 1;
            j2 = 1;
            k2 = 0;
        }
        double x1 = x0 - (double)i1 + 0.16666666666666666;
        double y1 = y0 - (double)j1 + 0.16666666666666666;
        double z1 = z0 - (double)k1 + 0.16666666666666666;
        double x2 = x0 - (double)i2 + 0.3333333333333333;
        double y2 = y0 - (double)j2 + 0.3333333333333333;
        double z2 = z0 - (double)k2 + 0.3333333333333333;
        double x3 = x0 - 1.0 + 0.5;
        double y3 = y0 - 1.0 + 0.5;
        double z3 = z0 - 1.0 + 0.5;
        double n0 = 0.0;
        double t0 = 0.6 - x0 * x0 - y0 * y0 - z0 * z0;
        if (t0 >= 0.0) {
            t0 *= t0;
            n0 = t0 * t0 * SimplexNoiseEngine.grad(this.p[i + this.p[j + this.p[k & 0xFF] & 0xFF] & 0xFF] & 0xFF, x0, y0, z0);
        }
        double n1 = 0.0;
        double t1 = 0.6 - x1 * x1 - y1 * y1 - z1 * z1;
        if (t1 >= 0.0) {
            t1 *= t1;
            n1 = t1 * t1 * SimplexNoiseEngine.grad(this.p[i + i1 + this.p[j + j1 + this.p[k + k1 & 0xFF] & 0xFF] & 0xFF] & 0xFF, x1, y1, z1);
        }
        double n2 = 0.0;
        double t22 = 0.6 - x2 * x2 - y2 * y2 - z2 * z2;
        if (t22 >= 0.0) {
            t22 *= t22;
            n2 = t22 * t22 * SimplexNoiseEngine.grad(this.p[i + i2 + this.p[j + j2 + this.p[k + k2 & 0xFF] & 0xFF] & 0xFF] & 0xFF, x2, y2, z2);
        }
        double n3 = 0.0;
        double t3 = 0.6 - x3 * x3 - y3 * y3 - z3 * z3;
        if (t3 >= 0.0) {
            t3 *= t3;
            n3 = t3 * t3 * SimplexNoiseEngine.grad(this.p[i + 1 + this.p[j + 1 + this.p[k + 1 & 0xFF] & 0xFF] & 0xFF], x3, y3, z3);
        }
        return (n0 + n1 + n2 + n3) * 32.0;
    }
}

