/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.noise.engine;

import lombok.NonNull;
import net.daporkchop.lib.common.math.PMath;
import net.daporkchop.lib.noise.NoiseSource;
import net.daporkchop.lib.random.PRandom;

public class PorkianV2NoiseEngine
implements NoiseSource {
    protected static final double DOUBLE_UNIT = (double)1.110223E-16f;
    protected final long seed;

    protected static double fade(double t2) {
        return t2 * t2 * (-t2 * 2.0 + 3.0);
    }

    public PorkianV2NoiseEngine(@NonNull PRandom random) {
        if (random == null) {
            throw new NullPointerException("random");
        }
        this.seed = random.nextLong();
    }

    @Override
    public double get(double x) {
        int xI = PMath.floorI(x);
        x = PorkianV2NoiseEngine.fade(x - (double)xI);
        return PorkianV2NoiseEngine.fade(PMath.lerp(this.mix(xI), this.mix(xI + 1), x)) * 2.0 - 1.0;
    }

    @Override
    public double get(double x, double y) {
        int xI = PMath.floorI(x);
        int yI = PMath.floorI(y);
        x = PorkianV2NoiseEngine.fade(x - (double)xI);
        y = PorkianV2NoiseEngine.fade(y - (double)yI);
        return PorkianV2NoiseEngine.fade(PMath.lerp(PorkianV2NoiseEngine.fade(PMath.lerp(this.mix(xI, yI), this.mix(xI + 1, yI), x)), PorkianV2NoiseEngine.fade(PMath.lerp(this.mix(xI, yI + 1), this.mix(xI + 1, yI + 1), x)), y)) * 2.0 - 1.0;
    }

    @Override
    public double get(double x, double y, double z) {
        int xI = PMath.floorI(x);
        int yI = PMath.floorI(y);
        int zI = PMath.floorI(z);
        x = PorkianV2NoiseEngine.fade(x - (double)xI);
        y = PorkianV2NoiseEngine.fade(y - (double)yI);
        z = PorkianV2NoiseEngine.fade(z - (double)zI);
        return PorkianV2NoiseEngine.fade(PMath.lerp(PorkianV2NoiseEngine.fade(PMath.lerp(PorkianV2NoiseEngine.fade(PMath.lerp(this.mix(xI, yI, zI), this.mix(xI + 1, yI, zI), x)), PorkianV2NoiseEngine.fade(PMath.lerp(this.mix(xI, yI + 1, zI), this.mix(xI + 1, yI + 1, zI), x)), y)), PorkianV2NoiseEngine.fade(PMath.lerp(PorkianV2NoiseEngine.fade(PMath.lerp(this.mix(xI, yI, zI + 1), this.mix(xI + 1, yI, zI + 1), x)), PorkianV2NoiseEngine.fade(PMath.lerp(this.mix(xI, yI + 1, zI + 1), this.mix(xI + 1, yI + 1, zI + 1), x)), y)), z)) * 2.0 - 1.0;
    }

    private double mix(int x) {
        return (double)(PMath.mix64((long)x ^ this.seed) >>> 11) * (double)1.110223E-16f;
    }

    private double mix(int x, int y) {
        return (double)(PMath.mix64((long)y ^ this.seed ^ PMath.mix64((long)x ^ this.seed)) >>> 11) * (double)1.110223E-16f;
    }

    private double mix(int x, int y, int z) {
        return (double)(PMath.mix64((long)z ^ this.seed ^ PMath.mix64((long)y ^ this.seed ^ PMath.mix64((long)x ^ this.seed))) >>> 11) * (double)1.110223E-16f;
    }

    public String toString() {
        return this.getClass().getCanonicalName();
    }

    public PorkianV2NoiseEngine(long seed) {
        this.seed = seed;
    }
}

