/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.noise.engine;

import lombok.NonNull;
import net.daporkchop.lib.common.math.PMath;
import net.daporkchop.lib.common.ref.Ref;
import net.daporkchop.lib.noise.NoiseSource;
import net.daporkchop.lib.random.PRandom;

public class PerlinNoiseEngine
implements NoiseSource {
    protected static final Ref<byte[]> INITIAL_STATE_CACHE = Ref.soft(() -> {
        byte[] arr = new byte[256];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = (byte)i;
        }
        return arr;
    });
    protected final byte[] p;

    protected static double fade(double t2) {
        return t2 * t2 * t2 * (t2 * (t2 * 6.0 - 15.0) + 10.0);
    }

    protected static double grad(int hash, double x) {
        if ((hash & 8) == 0) {
            return -(1.0 + (double)(hash & 7)) * x;
        }
        return (1.0 + (double)(hash & 7)) * x;
    }

    protected static double grad(int hash, double x, double y) {
        switch (hash & 7) {
            case 0: {
                return -x - 2.0 * y;
            }
            case 1: {
                return x - 2.0 * y;
            }
            case 2: {
                return -x + 2.0 * y;
            }
            case 3: {
                return x + 2.0 * y;
            }
            case 4: {
                return -y - 2.0 * x;
            }
            case 5: {
                return y - 2.0 * x;
            }
            case 6: {
                return -y + 2.0 * x;
            }
            case 7: {
                return y + 2.0 * x;
            }
        }
        throw new IllegalStateException();
    }

    protected static double grad(int hash, double x, double y, double z) {
        switch (hash & 0xF) {
            case 0: {
                return x + y;
            }
            case 1: {
                return -x + y;
            }
            case 2: {
                return x - y;
            }
            case 3: {
                return -x - y;
            }
            case 4: {
                return x + z;
            }
            case 5: {
                return -x + z;
            }
            case 6: {
                return x - z;
            }
            case 7: {
                return -x - z;
            }
            case 8: {
                return y + z;
            }
            case 9: {
                return -y + z;
            }
            case 10: {
                return y - z;
            }
            case 11: {
                return -y - z;
            }
            case 12: {
                return y + x;
            }
            case 13: {
                return -y + z;
            }
            case 14: {
                return y - x;
            }
            case 15: {
                return -y - z;
            }
        }
        throw new IllegalStateException();
    }

    public PerlinNoiseEngine(@NonNull PRandom random) {
        if (random == null) {
            throw new NullPointerException("random");
        }
        this.p = random.shuffle((byte[])INITIAL_STATE_CACHE.get().clone());
    }

    @Override
    public double get(double x) {
        int ix0 = PMath.floorI(x);
        double fx0 = x - (double)ix0;
        double fx1 = fx0 - 1.0;
        int ix1 = ix0 + 1 & 0xFF;
        double s2 = PerlinNoiseEngine.fade(fx0);
        double n0 = PerlinNoiseEngine.grad(this.p[ix0 &= 0xFF] & 0xFF, fx0);
        double n1 = PerlinNoiseEngine.grad(this.p[ix1] & 0xFF, fx1);
        return PMath.lerp(n0, n1, s2) * 0.188;
    }

    @Override
    public double get(double x, double y) {
        int ix0 = PMath.floorI(x);
        int iy0 = PMath.floorI(y);
        double fx0 = x - (double)ix0;
        double fy0 = y - (double)iy0;
        double fx1 = fx0 - 1.0;
        double fy1 = fy0 - 1.0;
        int ix1 = ix0 + 1 & 0xFF;
        int iy1 = iy0 + 1 & 0xFF;
        double t2 = PerlinNoiseEngine.fade(fy0);
        double s2 = PerlinNoiseEngine.fade(fx0);
        double nx0 = PerlinNoiseEngine.grad(this.p[(ix0 &= 0xFF) + this.p[iy0 &= 0xFF] & 0xFF] & 0xFF, fx0, fy0);
        double nx1 = PerlinNoiseEngine.grad(this.p[ix0 + this.p[iy1] & 0xFF] & 0xFF, fx0, fy1);
        double n0 = PMath.lerp(nx0, nx1, t2);
        nx0 = PerlinNoiseEngine.grad(this.p[ix1 + this.p[iy0] & 0xFF] & 0xFF, fx1, fy0);
        nx1 = PerlinNoiseEngine.grad(this.p[ix1 + this.p[iy1] & 0xFF] & 0xFF, fx1, fy1);
        double n1 = PMath.lerp(nx0, nx1, t2);
        return PMath.lerp(n0, n1, s2) * 0.507;
    }

    @Override
    public double get(double x, double y, double z) {
        int ix0 = PMath.floorI(x);
        int iy0 = PMath.floorI(y);
        int iz0 = PMath.floorI(z);
        double fx0 = x - (double)ix0;
        double fy0 = y - (double)iy0;
        double fz0 = z - (double)iz0;
        double fx1 = fx0 - 1.0;
        double fy1 = fy0 - 1.0;
        double fz1 = fz0 - 1.0;
        int ix1 = ix0 + 1 & 0xFF;
        int iy1 = iy0 + 1 & 0xFF;
        int iz1 = iz0 + 1 & 0xFF;
        double r = PerlinNoiseEngine.fade(fz0);
        double t2 = PerlinNoiseEngine.fade(fy0);
        double s2 = PerlinNoiseEngine.fade(fx0);
        double nxy0 = PerlinNoiseEngine.grad(this.p[(ix0 &= 0xFF) + this.p[(iy0 &= 0xFF) + this.p[iz0 &= 0xFF] & 0xFF] & 0xFF] & 0xFF, fx0, fy0, fz0);
        double nxy1 = PerlinNoiseEngine.grad(this.p[ix0 + this.p[iy0 + this.p[iz1] & 0xFF] & 0xFF] & 0xFF, fx0, fy0, fz1);
        double nx0 = PMath.lerp(nxy0, nxy1, r);
        nxy0 = PerlinNoiseEngine.grad(this.p[ix0 + this.p[iy1 + this.p[iz0] & 0xFF] & 0xFF] & 0xFF, fx0, fy1, fz0);
        nxy1 = PerlinNoiseEngine.grad(this.p[ix0 + this.p[iy1 + this.p[iz1] & 0xFF] & 0xFF] & 0xFF, fx0, fy1, fz1);
        double nx1 = PMath.lerp(nxy0, nxy1, r);
        double n0 = PMath.lerp(nx0, nx1, t2);
        nxy0 = PerlinNoiseEngine.grad(this.p[ix1 + this.p[iy0 + this.p[iz0] & 0xFF] & 0xFF] & 0xFF, fx1, fy0, fz0);
        nxy1 = PerlinNoiseEngine.grad(this.p[ix1 + this.p[iy0 + this.p[iz1] & 0xFF] & 0xFF] & 0xFF, fx1, fy0, fz1);
        nx0 = PMath.lerp(nxy0, nxy1, r);
        nxy0 = PerlinNoiseEngine.grad(this.p[ix1 + this.p[iy1 + this.p[iz0] & 0xFF] & 0xFF] & 0xFF, fx1, fy1, fz0);
        nxy1 = PerlinNoiseEngine.grad(this.p[ix1 + this.p[iy1 + this.p[iz1] & 0xFF] & 0xFF] & 0xFF, fx1, fy1, fz1);
        nx1 = PMath.lerp(nxy0, nxy1, r);
        double n1 = PMath.lerp(nx0, nx1, t2);
        return PMath.lerp(n0, n1, s2) * 0.87;
    }

    public String toString() {
        return this.getClass().getCanonicalName();
    }
}

