/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.noise.engine;

import lombok.NonNull;
import net.daporkchop.lib.common.math.PMath;
import net.daporkchop.lib.noise.NoiseSource;
import net.daporkchop.lib.noise.filter.LerpFilter;
import net.daporkchop.lib.noise.filter.math.ScalarAddFilter;
import net.daporkchop.lib.noise.filter.math.ScalarMulFilter;
import net.daporkchop.lib.noise.filter.math.ScalarSubFilter;

public final class NoopNoiseEngine
implements NoiseSource {
    private final double val;
    private final double min;
    private final double max;

    @Override
    public double get(double x) {
        return this.val;
    }

    @Override
    public double get(double x, double y) {
        return this.val;
    }

    @Override
    public double get(double x, double y, double z) {
        return this.val;
    }

    @Override
    public NoiseSource lerped(@NonNull NoiseSource a, @NonNull NoiseSource b) {
        if (a == null) {
            throw new NullPointerException("a");
        }
        if (b == null) {
            throw new NullPointerException("b");
        }
        if (this.val == this.min) {
            return a;
        }
        if (this.val == this.max) {
            return b;
        }
        return new LerpFilter(a, b, this);
    }

    @Override
    public NoiseSource scaled(double scale) {
        return this;
    }

    @Override
    public NoiseSource scaled(double scaleX, double scaleY, double scaleZ) {
        return this;
    }

    @Override
    public NoiseSource octaves(int octaves) {
        return this.val == 0.0 ? this : this.mul(octaves);
    }

    @Override
    public NoiseSource weighted() {
        return this;
    }

    @Override
    public NoiseSource toRange(double min2, double max) {
        return min2 == this.min && max == this.max ? this : new NoopNoiseEngine(PMath.lerp(min2, max, (this.val - this.min) / (this.max - this.min)), min2, max);
    }

    @Override
    public NoiseSource add(double val) {
        return val == 0.0 ? this : new NoopNoiseEngine(this.val + val, this.min + val, this.max + val);
    }

    @Override
    public NoiseSource add(@NonNull NoiseSource val) {
        if (val == null) {
            throw new NullPointerException("val");
        }
        return this.val == 0.0 ? val : new ScalarAddFilter(val, this.val);
    }

    @Override
    public NoiseSource sub(double val) {
        return val == 0.0 ? this : new NoopNoiseEngine(this.val - val, this.min - val, this.max - val);
    }

    @Override
    public NoiseSource sub(@NonNull NoiseSource val) {
        if (val == null) {
            throw new NullPointerException("val");
        }
        return this.val == 0.0 ? val : new ScalarSubFilter(val, this.val);
    }

    @Override
    public NoiseSource mul(double val) {
        if (this.val == 0.0 || val == 0.0) {
            return ZERO;
        }
        if (val == 1.0) {
            return this;
        }
        return new NoopNoiseEngine(this.val * val, this.val * val, this.val * val + 1.0);
    }

    @Override
    public NoiseSource mul(@NonNull NoiseSource val) {
        if (val == null) {
            throw new NullPointerException("val");
        }
        if (this.val == 0.0) {
            return ZERO;
        }
        if (this.val == 1.0) {
            return val;
        }
        return new ScalarMulFilter(val, this.val);
    }

    public String toString() {
        return String.valueOf(this.val);
    }

    public NoopNoiseEngine(double val, double min2, double max) {
        this.val = val;
        this.min = min2;
        this.max = max;
    }

    @Override
    public double min() {
        return this.min;
    }

    @Override
    public double max() {
        return this.max;
    }
}

