/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.noise;

import lombok.NonNull;
import net.daporkchop.lib.common.util.PValidation;
import net.daporkchop.lib.noise.engine.NoopNoiseEngine;
import net.daporkchop.lib.noise.filter.LerpFilter;
import net.daporkchop.lib.noise.filter.OctaveFilter;
import net.daporkchop.lib.noise.filter.ScaleFilter;
import net.daporkchop.lib.noise.filter.WeightedFilter;
import net.daporkchop.lib.noise.filter.math.ScalarAddFilter;
import net.daporkchop.lib.noise.filter.math.ScalarMulFilter;
import net.daporkchop.lib.noise.filter.math.ScalarSubFilter;
import net.daporkchop.lib.noise.filter.math.SourceAddFilter;
import net.daporkchop.lib.noise.filter.math.SourceMulFilter;
import net.daporkchop.lib.noise.filter.math.SourceSubFilter;
import net.daporkchop.lib.noise.filter.range.RangeConversionFilter;

public interface NoiseSource {
    public static final NoopNoiseEngine ZERO = new NoopNoiseEngine(0.0, 0.0, 1.0);

    default public double min() {
        return -1.0;
    }

    default public double max() {
        return 1.0;
    }

    public double get(double var1);

    public double get(double var1, double var3);

    public double get(double var1, double var3, double var5);

    default public double[] get(double startX, double stepX, int sizeX) {
        return this.get(null, startX, stepX, sizeX);
    }

    default public double[] get(double[] dst, double startX, double stepX, int sizeX) {
        if (dst == null || dst.length < PValidation.notNegative(sizeX)) {
            dst = new double[sizeX];
        }
        double x = startX;
        int currX = 0;
        while (currX < sizeX) {
            dst[currX] = this.get(x);
            ++currX;
            x += stepX;
        }
        return dst;
    }

    default public double[] get(double startX, double startY, double stepX, double stepY, int sizeX, int sizeY) {
        return this.get(null, startX, startY, stepX, stepY, sizeX, sizeY);
    }

    default public double[] get(double[] dst, double startX, double startY, double stepX, double stepY, int sizeX, int sizeY) {
        if (dst == null || dst.length < PValidation.notNegative(sizeX) * PValidation.notNegative(sizeY)) {
            dst = new double[sizeX * sizeY];
        }
        int i = 0;
        double x = startX;
        int currX = 0;
        while (currX < sizeX) {
            double y = startY;
            int currY = 0;
            while (currY < sizeY) {
                dst[i++] = this.get(x, y);
                ++currY;
                y += stepY;
            }
            ++currX;
            x += stepX;
        }
        return dst;
    }

    default public double[] get(double startX, double startY, double startZ, double stepX, double stepY, double stepZ, int sizeX, int sizeY, int sizeZ) {
        return this.get(null, startX, startY, startZ, stepX, stepY, stepZ, sizeX, sizeY, sizeZ);
    }

    default public double[] get(double[] dst, double startX, double startY, double startZ, double stepX, double stepY, double stepZ, int sizeX, int sizeY, int sizeZ) {
        if (dst == null || dst.length < PValidation.notNegative(sizeX) * PValidation.notNegative(sizeY) * PValidation.notNegative(sizeZ)) {
            dst = new double[sizeX * sizeY * sizeZ];
        }
        int i = 0;
        double x = startX;
        int currX = 0;
        while (currX < sizeX) {
            double y = startY;
            int currY = 0;
            while (currY < sizeY) {
                double z = startZ;
                int currZ = 0;
                while (currZ < sizeZ) {
                    dst[i++] = this.get(x, y, z);
                    ++currZ;
                    z += stepZ;
                }
                ++currY;
                y += stepY;
            }
            ++currX;
            x += stepX;
        }
        return dst;
    }

    default public NoiseSource lerped(@NonNull NoiseSource a, @NonNull NoiseSource b) {
        if (a == null) {
            throw new NullPointerException("a");
        }
        if (b == null) {
            throw new NullPointerException("b");
        }
        return new LerpFilter(a, b, this);
    }

    default public NoiseSource octaves(int octaves) {
        return octaves == 1 ? this : new OctaveFilter(this, octaves);
    }

    default public NoiseSource scaled(double scale) {
        return scale == 1.0 ? this : new ScaleFilter(this, scale, scale, scale);
    }

    default public NoiseSource scaled(double scaleX, double scaleY, double scaleZ) {
        return scaleX == 1.0 && scaleY == 1.0 && scaleZ == 1.0 ? this : new ScaleFilter(this, scaleX, scaleY, scaleZ);
    }

    default public NoiseSource weighted() {
        return new WeightedFilter(this);
    }

    default public NoiseSource toRange(double min2, double max) {
        return min2 == this.min() && max == this.max() ? this : new RangeConversionFilter(this, min2, max);
    }

    default public NoiseSource add(double val) {
        return val == 0.0 ? this : new ScalarAddFilter(this, val);
    }

    default public NoiseSource add(@NonNull NoiseSource val) {
        if (val == null) {
            throw new NullPointerException("val");
        }
        return val == this ? this.mul(2.0) : new SourceAddFilter(this, val);
    }

    default public NoiseSource sub(double val) {
        return val == 0.0 ? this : new ScalarSubFilter(this, val);
    }

    default public NoiseSource sub(@NonNull NoiseSource val) {
        if (val == null) {
            throw new NullPointerException("val");
        }
        return val == this ? ZERO : new SourceSubFilter(this, val);
    }

    default public NoiseSource mul(double val) {
        if (val == 0.0) {
            return ZERO;
        }
        if (val == 1.0) {
            return this;
        }
        return new ScalarMulFilter(this, val);
    }

    default public NoiseSource mul(@NonNull NoiseSource val) {
        if (val == null) {
            throw new NullPointerException("val");
        }
        return new SourceMulFilter(this, val);
    }
}

