/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.natives.impl;

import java.lang.reflect.Constructor;
import lombok.NonNull;
import net.daporkchop.lib.common.util.PorkUtil;
import net.daporkchop.lib.natives.Feature;
import net.daporkchop.lib.natives.NativeFeature;
import net.daporkchop.lib.natives.impl.FeatureImplementation;

public class NativeFeatureImplementation<F extends Feature<F>>
extends FeatureImplementation<F> {
    protected final String libName;
    protected final ClassLoader loader;

    public NativeFeatureImplementation(String className, @NonNull String libName, @NonNull ClassLoader loader) {
        super(className);
        if (libName == null) {
            throw new NullPointerException("libName");
        }
        if (loader == null) {
            throw new NullPointerException("loader");
        }
        this.libName = libName;
        this.loader = loader;
    }

    @Override
    public F create() throws Throwable {
        Class clazz = (Class)PorkUtil.uncheckedCast(NativeFeature.loadNativeLibrary(this.libName, this.className, this.loader));
        Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        return (F)((Feature)constructor.newInstance(new Object[0]));
    }

    @Override
    public String toString() {
        return String.format("NativeFeatureImplementation(class=%s, lib=%s, loader=%s)", this.className, this.libName, this.loader);
    }
}

