/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.natives.impl;

import lombok.NonNull;
import net.daporkchop.lib.common.util.PValidation;
import net.daporkchop.lib.natives.Feature;
import net.daporkchop.lib.natives.impl.FeatureImplementation;

public class CheckedFeatureWrapper<F extends Feature<F>>
extends FeatureImplementation<F> {
    protected final FeatureImplementation<F> delegate;
    protected final Runnable[] checks;

    public CheckedFeatureWrapper(@NonNull FeatureImplementation<F> delegate, Runnable ... checks) {
        super(delegate.className);
        if (delegate == null) {
            throw new NullPointerException("delegate");
        }
        if (checks == null) {
            throw new NullPointerException("checks");
        }
        this.delegate = delegate;
        for (Runnable check : this.checks = (Runnable[])checks.clone()) {
            PValidation.checkArg(check != null, "no checks may be null!");
        }
    }

    @Override
    public F create() throws Throwable {
        for (Runnable check : this.checks) {
            check.run();
        }
        return this.delegate.create();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }
}

