/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.natives;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.UUID;
import lombok.NonNull;
import net.daporkchop.lib.common.system.PlatformInfo;
import net.daporkchop.lib.natives.Feature;
import net.daporkchop.lib.natives.util.exception.NativeFeaturesUnavailableException;

public abstract class NativeFeature<F extends Feature<F>>
implements Feature<F> {
    private static final String LIB_ARCH;
    private static final String LIB_EXT;
    public static final boolean AVAILABLE;

    public static String formatLibName(@NonNull String libName) {
        if (libName == null) {
            throw new NullPointerException("libName");
        }
        String prefix = "";
        if (libName.startsWith("/")) {
            libName = libName.substring(1);
            prefix = "";
        }
        String format = libName.isEmpty() ? "%1$s%2$s.%4$s" : "%1$s%2$s/%3$s.%4$s";
        return String.format(format, prefix, LIB_ARCH, libName, LIB_EXT);
    }

    public static Class<?> loadNativeLibrary(@NonNull String libName, @NonNull String className, @NonNull ClassLoader classLoader) throws Throwable {
        if (libName == null) {
            throw new NullPointerException("libName");
        }
        if (className == null) {
            throw new NullPointerException("className");
        }
        if (classLoader == null) {
            throw new NullPointerException("classLoader");
        }
        if (!AVAILABLE) {
            throw new NativeFeaturesUnavailableException(libName);
        }
        Class<?> clazz = Class.forName(className, false, classLoader);
        String libPath = NativeFeature.formatLibName(libName);
        File tempFile = File.createTempFile(libName + UUID.randomUUID(), '.' + LIB_EXT);
        try (InputStream in = clazz.getResourceAsStream(libPath);){
            if (in == null) {
                tempFile.delete();
                throw new FileNotFoundException("resource: " + libPath + ", class: " + clazz.getCanonicalName());
            }
            Files.copy(in, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        tempFile.deleteOnExit();
        NativeFeature.loadNativeLibrary(clazz, tempFile);
        return clazz;
    }

    public static void loadNativeLibrary(@NonNull Class<?> loaderClass, @NonNull File file) throws Throwable {
        if (loaderClass == null) {
            throw new NullPointerException("loaderClass");
        }
        if (file == null) {
            throw new NullPointerException("file");
        }
        try {
            Method method = Runtime.class.getDeclaredMethod("load0", Class.class, String.class);
            method.setAccessible(true);
            method.invoke((Object)Runtime.getRuntime(), loaderClass, file.getAbsolutePath());
        }
        catch (NoSuchMethodException | SecurityException e) {
            System.load(file.getAbsolutePath());
        }
    }

    @Override
    public boolean isNative() {
        return true;
    }

    static {
        switch (PlatformInfo.OPERATING_SYSTEM) {
            case Linux: {
                switch (PlatformInfo.ARCHITECTURE) {
                    case ARM: {
                        LIB_ARCH = "arm-linux-gnueabihf";
                        break;
                    }
                    case AARCH64: {
                        LIB_ARCH = "aarch64-linux-gnu";
                        break;
                    }
                    case x86_64: {
                        LIB_ARCH = "x86_64-linux-gnu";
                        break;
                    }
                    default: {
                        LIB_ARCH = null;
                    }
                }
                LIB_EXT = LIB_ARCH == null ? null : "so";
                break;
            }
            case Windows: {
                switch (PlatformInfo.ARCHITECTURE) {
                    case x86_64: {
                        LIB_ARCH = "x86_64-w64-mingw32";
                        break;
                    }
                    default: {
                        LIB_ARCH = null;
                    }
                }
                LIB_EXT = LIB_ARCH == null ? null : "dll";
                break;
            }
            default: {
                LIB_ARCH = null;
                LIB_EXT = null;
            }
        }
        AVAILABLE = LIB_ARCH != null;
    }
}

