/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.natives;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import net.daporkchop.lib.natives.Feature;
import net.daporkchop.lib.natives.impl.FeatureImplementation;
import net.daporkchop.lib.natives.impl.JavaFeatureImplementation;
import net.daporkchop.lib.natives.impl.NativeFeatureImplementation;
import net.daporkchop.lib.natives.util.exception.FeatureImplementationLoadException;
import net.daporkchop.lib.natives.util.exception.NoFeatureImplementationsFoundException;
import net.daporkchop.lib.unsafe.PUnsafe;

public final class FeatureBuilder<F extends Feature<F>> {
    private final List<FeatureImplementation<F>> implementations = new ArrayList<FeatureImplementation<F>>();
    @NonNull
    private final Class<?> currentClass;

    public static <F extends Feature<F>> FeatureBuilder<F> create(@NonNull Class<?> currentClass) {
        if (currentClass == null) {
            throw new NullPointerException("currentClass");
        }
        return new FeatureBuilder<F>(currentClass);
    }

    public FeatureBuilder<F> addNative(@NonNull String className) {
        if (className == null) {
            throw new NullPointerException("className");
        }
        return this.add(new NativeFeatureImplementation(className, "", this.currentClass.getClassLoader()));
    }

    public FeatureBuilder<F> addNative(@NonNull String className, @NonNull String libName) {
        if (className == null) {
            throw new NullPointerException("className");
        }
        if (libName == null) {
            throw new NullPointerException("libName");
        }
        return this.add(new NativeFeatureImplementation(className, libName, this.currentClass.getClassLoader()));
    }

    public FeatureBuilder<F> addNative(@NonNull String className, @NonNull String libName, @NonNull Class<?> currentClass) {
        if (className == null) {
            throw new NullPointerException("className");
        }
        if (libName == null) {
            throw new NullPointerException("libName");
        }
        if (currentClass == null) {
            throw new NullPointerException("currentClass");
        }
        return this.add(new NativeFeatureImplementation(className, libName, currentClass.getClassLoader()));
    }

    public FeatureBuilder<F> addNative(@NonNull String className, @NonNull String libName, @NonNull ClassLoader loader) {
        if (className == null) {
            throw new NullPointerException("className");
        }
        if (libName == null) {
            throw new NullPointerException("libName");
        }
        if (loader == null) {
            throw new NullPointerException("loader");
        }
        return this.add(new NativeFeatureImplementation(className, libName, loader));
    }

    public FeatureBuilder<F> addJava(@NonNull String className) {
        if (className == null) {
            throw new NullPointerException("className");
        }
        return this.add(new JavaFeatureImplementation(className, this.currentClass.getClassLoader()));
    }

    public FeatureBuilder<F> addJava(@NonNull String className, @NonNull Class<?> currentClass) {
        if (className == null) {
            throw new NullPointerException("className");
        }
        if (currentClass == null) {
            throw new NullPointerException("currentClass");
        }
        return this.add(new JavaFeatureImplementation(className, currentClass.getClassLoader()));
    }

    public FeatureBuilder<F> addJava(@NonNull String className, @NonNull ClassLoader loader) {
        if (className == null) {
            throw new NullPointerException("className");
        }
        if (loader == null) {
            throw new NullPointerException("loader");
        }
        return this.add(new JavaFeatureImplementation(className, loader));
    }

    public synchronized FeatureBuilder<F> add(@NonNull FeatureImplementation<F> implementation) {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        this.implementations.add(implementation);
        return this;
    }

    public F build() {
        return this.build(Boolean.parseBoolean(System.getProperty("porklib.native.printStackTraces", "false")));
    }

    public synchronized F build(boolean printStackTraces) {
        ArrayList<FeatureImplementationLoadException> errors = new ArrayList<FeatureImplementationLoadException>();
        for (FeatureImplementation<F> implementation : this.implementations) {
            try {
                return (F)((Feature)Objects.requireNonNull(implementation.create(), "instance was null!"));
            }
            catch (OutOfMemoryError outOfMemoryError) {
            }
            catch (Throwable t2) {
                if (printStackTraces) {
                    t2.printStackTrace();
                }
                errors.add(new FeatureImplementationLoadException(implementation.toString(), t2));
            }
        }
        NoFeatureImplementationsFoundException e = new NoFeatureImplementationsFoundException(this.currentClass.getCanonicalName(), errors);
        PUnsafe.throwException(e);
        throw new IllegalStateException(e);
    }

    private FeatureBuilder(@NonNull Class<?> currentClass) {
        if (currentClass == null) {
            throw new NullPointerException("currentClass");
        }
        this.currentClass = currentClass;
    }
}

