/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.util;

import java.awt.FlowLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import lombok.NonNull;
import net.daporkchop.lib.common.misc.string.PUnsafeStrings;
import net.daporkchop.lib.common.pool.handle.HandledPool;
import net.daporkchop.lib.unsafe.PUnsafe;

public final class PorkUtil {
    protected static final long MATCHER_GROUPS_OFFSET = PUnsafe.pork_getOffset(Matcher.class, "groups");
    protected static final long MATCHER_TEXT_OFFSET = PUnsafe.pork_getOffset(Matcher.class, "text");
    public static final int TINY_BUFFER_SIZE = 32;
    public static final int BUFFER_SIZE = 65536;
    public static final HandledPool<byte[]> TINY_BUFFER_POOL = HandledPool.threadLocal(() -> new byte[32], 4);
    public static final HandledPool<ByteBuffer> DIRECT_TINY_BUFFER_POOL = HandledPool.threadLocal(() -> ByteBuffer.allocateDirect(32), 4);
    public static final HandledPool<byte[]> BUFFER_POOL = HandledPool.threadLocal(() -> new byte[65536], 4);
    public static final HandledPool<ByteBuffer> DIRECT_BUFFER_POOL = HandledPool.threadLocal(() -> ByteBuffer.allocateDirect(65536), 4);
    public static final HandledPool<StringBuilder> STRINGBUILDER_POOL = HandledPool.threadLocal(StringBuilder::new, 4);
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    public static final String PORKLIB_VERSION = "0.5.4-SNAPSHOT";
    public static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public static CharSequence subSequence(@NonNull CharSequence seq, int start, int end) {
        if (seq == null) {
            throw new NullPointerException("seq");
        }
        if (start == 0 && end == seq.length()) {
            return seq;
        }
        char[] arr = PUnsafeStrings.tryUnwrap(seq);
        return arr != null ? CharBuffer.wrap(arr, start, end - start) : seq.subSequence(start, end);
    }

    public static <T> T fallbackIfNull(T value, Object fallback) {
        return value != null ? value : PorkUtil.uncheckedCast(fallback);
    }

    public static <T> Class<T> classForName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Class<T> classForName(@NonNull String name, ClassLoader loader) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        try {
            return Class.forName(name, true, loader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Class<T> uninitializedClassForName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        try {
            return Class.forName(name, false, null);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Class<T> uninitializedClassForName(@NonNull String name, ClassLoader loader) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        try {
            return Class.forName(name, false, loader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean classExistsWithName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        try {
            Class.forName(name);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Method getMethod(@NonNull Class<?> clazz, @NonNull String name, Class<?> ... params) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (params == null) {
            throw new NullPointerException("params");
        }
        try {
            return clazz.getDeclaredMethod(name, params);
        }
        catch (NoSuchMethodException e) {
            try {
                return clazz.getMethod(name, params);
            }
            catch (NoSuchMethodException e1) {
                throw new RuntimeException(e);
            }
        }
    }

    public static <K, V> Map<K, V> newSoftCache() {
        try {
            Class<?> clazz = Class.forName("sun.misc.SoftCache");
            return (Map)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to find class: sun.misc.SoftCache", e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e.getCause() == null ? e : e.getCause());
        }
    }

    public static void simpleDisplayImage(@NonNull BufferedImage img) {
        if (img == null) {
            throw new NullPointerException("img");
        }
        PorkUtil.simpleDisplayImage(false, img);
    }

    public static void simpleDisplayImage(boolean block, BufferedImage ... imgs) {
        if (imgs == null) {
            throw new NullPointerException("imgs");
        }
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new FlowLayout());
        for (BufferedImage img : imgs) {
            frame.getContentPane().add(new JLabel(new ImageIcon(img)));
        }
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(2);
        if (block) {
            final CompletableFuture future = new CompletableFuture();
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    future.complete(null);
                }
            });
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static String className(Object obj) {
        return obj == null ? "null" : obj.getClass().getCanonicalName();
    }

    public static void unsafe_forceGC() {
        Object obj = new Object();
        long oldMem = Runtime.getRuntime().freeMemory();
        obj = null;
        do {
            System.gc();
        } while (Runtime.getRuntime().freeMemory() <= oldMem);
    }

    public static Object getNull() {
        return null;
    }

    public static CharSequence fastGroup(@NonNull Matcher matcher, int group) {
        if (matcher == null) {
            throw new NullPointerException("matcher");
        }
        matcher.start();
        if (group < 0 || group > matcher.groupCount()) {
            throw new IndexOutOfBoundsException("No group " + group);
        }
        int[] groups = (int[])PUnsafe.getObject(matcher, MATCHER_GROUPS_OFFSET);
        int start = groups[group << 1];
        int end = groups[(group << 1) + 1];
        if (start == -1 || end == -1) {
            return null;
        }
        return ((CharSequence)PUnsafe.getObject(matcher, MATCHER_TEXT_OFFSET)).subSequence(start, end);
    }

    public static <T> T uncheckedCast(Object value) {
        return (T)value;
    }

    public static <T> T newInstance(@NonNull Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            PUnsafe.throwException(e);
        }
        catch (InvocationTargetException e) {
            PUnsafe.throwException(e.getCause() != null ? e.getCause() : e);
        }
        throw new IllegalStateException();
    }

    private PorkUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

