/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.util;

import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.IntUnaryOperator;
import java.util.function.LongSupplier;
import java.util.function.LongUnaryOperator;
import java.util.function.Supplier;
import lombok.NonNull;
import net.daporkchop.lib.common.util.PValidation;

public final class PArrays {
    public static void shuffle(@NonNull byte[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        PArrays.shuffle(arr, (Random)ThreadLocalRandom.current());
    }

    public static void shuffle(@NonNull byte[] arr, @NonNull Random random) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        if (random == null) {
            throw new NullPointerException("random");
        }
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            PArrays.swap(arr, i, random.nextInt(length));
        }
    }

    public static void shuffle(@NonNull short[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        PArrays.shuffle(arr, (Random)ThreadLocalRandom.current());
    }

    public static void shuffle(@NonNull short[] arr, @NonNull Random random) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        if (random == null) {
            throw new NullPointerException("random");
        }
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            PArrays.swap(arr, i, random.nextInt(length));
        }
    }

    public static void shuffle(@NonNull char[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        PArrays.shuffle(arr, (Random)ThreadLocalRandom.current());
    }

    public static void shuffle(@NonNull char[] arr, @NonNull Random random) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        if (random == null) {
            throw new NullPointerException("random");
        }
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            PArrays.swap(arr, i, random.nextInt(length));
        }
    }

    public static void shuffle(@NonNull int[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        PArrays.shuffle(arr, (Random)ThreadLocalRandom.current());
    }

    public static void shuffle(@NonNull int[] arr, @NonNull Random random) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        if (random == null) {
            throw new NullPointerException("random");
        }
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            PArrays.swap(arr, i, random.nextInt(length));
        }
    }

    public static void shuffle(@NonNull long[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        PArrays.shuffle(arr, (Random)ThreadLocalRandom.current());
    }

    public static void shuffle(@NonNull long[] arr, @NonNull Random random) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        if (random == null) {
            throw new NullPointerException("random");
        }
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            PArrays.swap(arr, i, random.nextInt(length));
        }
    }

    public static void shuffle(@NonNull float[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        PArrays.shuffle(arr, (Random)ThreadLocalRandom.current());
    }

    public static void shuffle(@NonNull float[] arr, @NonNull Random random) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        if (random == null) {
            throw new NullPointerException("random");
        }
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            PArrays.swap(arr, i, random.nextInt(length));
        }
    }

    public static void shuffle(@NonNull double[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        PArrays.shuffle(arr, (Random)ThreadLocalRandom.current());
    }

    public static void shuffle(@NonNull double[] arr, @NonNull Random random) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        if (random == null) {
            throw new NullPointerException("random");
        }
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            PArrays.swap(arr, i, random.nextInt(length));
        }
    }

    public static <T> void shuffle(@NonNull T[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        PArrays.shuffle(arr, (Random)ThreadLocalRandom.current());
    }

    public static <T> void shuffle(@NonNull T[] arr, @NonNull Random random) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        if (random == null) {
            throw new NullPointerException("random");
        }
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            PArrays.swap(arr, i, random.nextInt(length));
        }
    }

    public static int[] filled(int size, @NonNull IntSupplier supplier) {
        if (supplier == null) {
            throw new NullPointerException("supplier");
        }
        int[] arr = new int[size];
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            arr[i] = supplier.getAsInt();
        }
        return arr;
    }

    public static int[] filled(int size, @NonNull IntUnaryOperator supplier) {
        if (supplier == null) {
            throw new NullPointerException("supplier");
        }
        int[] arr = new int[size];
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            arr[i] = supplier.applyAsInt(i);
        }
        return arr;
    }

    public static long[] filled(int size, @NonNull LongSupplier supplier) {
        if (supplier == null) {
            throw new NullPointerException("supplier");
        }
        long[] arr = new long[size];
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            arr[i] = supplier.getAsLong();
        }
        return arr;
    }

    public static long[] filled(int size, @NonNull LongUnaryOperator supplier) {
        if (supplier == null) {
            throw new NullPointerException("supplier");
        }
        long[] arr = new long[size];
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            arr[i] = supplier.applyAsLong(i);
        }
        return arr;
    }

    public static <T> T[] filled(int size, @NonNull IntFunction<T[]> arrayCreator, @NonNull Supplier<T> supplier) {
        if (arrayCreator == null) {
            throw new NullPointerException("arrayCreator");
        }
        if (supplier == null) {
            throw new NullPointerException("supplier");
        }
        T[] arr = arrayCreator.apply(size);
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            arr[i] = supplier.get();
        }
        return arr;
    }

    public static <T> T[] filled(int size, @NonNull IntFunction<T[]> arrayCreator, @NonNull IntFunction<T> supplier) {
        if (arrayCreator == null) {
            throw new NullPointerException("arrayCreator");
        }
        if (supplier == null) {
            throw new NullPointerException("supplier");
        }
        T[] arr = arrayCreator.apply(size);
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            arr[i] = supplier.apply(i);
        }
        return arr;
    }

    public static <T> void fill(@NonNull T[] arr, @NonNull Supplier<T> supplier) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        if (supplier == null) {
            throw new NullPointerException("supplier");
        }
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            arr[i] = supplier.get();
        }
    }

    public static <T> T[] fill(@NonNull T[] arr, @NonNull T value) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        Arrays.fill(arr, value);
        return arr;
    }

    public static <T> Object[] toObjects(@NonNull T[] src) {
        if (src == null) {
            throw new NullPointerException("src");
        }
        if (src.getClass() == Object[].class) {
            return src;
        }
        Object[] dst = new Object[src.length];
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    public static int indexOf(@NonNull byte[] arr, byte val) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            if (arr[i] != val) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(@NonNull byte[] arr, byte val, int from, int to) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        PValidation.checkRange(arr.length, from, to);
        while (from < to) {
            if (arr[from] == val) {
                return from;
            }
            ++from;
        }
        return -1;
    }

    public static int indexOf(@NonNull short[] arr, short val) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            if (arr[i] != val) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(@NonNull short[] arr, short val, int from, int to) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        PValidation.checkRange(arr.length, from, to);
        while (from < to) {
            if (arr[from] == val) {
                return from;
            }
            ++from;
        }
        return -1;
    }

    public static int indexOf(@NonNull char[] arr, char val) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            if (arr[i] != val) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(@NonNull char[] arr, char val, int from, int to) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        PValidation.checkRange(arr.length, from, to);
        while (from < to) {
            if (arr[from] == val) {
                return from;
            }
            ++from;
        }
        return -1;
    }

    public static int indexOf(@NonNull int[] arr, int val) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            if (arr[i] != val) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(@NonNull int[] arr, int val, int from, int to) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        PValidation.checkRange(arr.length, from, to);
        while (from < to) {
            if (arr[from] == val) {
                return from;
            }
            ++from;
        }
        return -1;
    }

    public static int indexOf(@NonNull long[] arr, long val) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            if (arr[i] != val) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(@NonNull long[] arr, long val, int from, int to) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        PValidation.checkRange(arr.length, from, to);
        while (from < to) {
            if (arr[from] == val) {
                return from;
            }
            ++from;
        }
        return -1;
    }

    public static int indexOf(@NonNull float[] arr, float val) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            if (arr[i] != val) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(@NonNull float[] arr, float val, int from, int to) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        PValidation.checkRange(arr.length, from, to);
        while (from < to) {
            if (arr[from] == val) {
                return from;
            }
            ++from;
        }
        return -1;
    }

    public static int indexOf(@NonNull double[] arr, double val) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            if (arr[i] != val) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(@NonNull double[] arr, double val, int from, int to) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        PValidation.checkRange(arr.length, from, to);
        while (from < to) {
            if (arr[from] == val) {
                return from;
            }
            ++from;
        }
        return -1;
    }

    public static <T> int indexOf(@NonNull T[] arr, @NonNull T val) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        if (val == null) {
            throw new NullPointerException("val");
        }
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            if (arr[i] != val) continue;
            return i;
        }
        return -1;
    }

    public static byte max(@NonNull byte[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        if (arr.length == 0) {
            throw new IllegalArgumentException("Array may not be empty!");
        }
        byte val = -128;
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            if (arr[i] <= val) continue;
            val = arr[i];
        }
        return val;
    }

    public static short max(@NonNull short[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        if (arr.length == 0) {
            throw new IllegalArgumentException("Array may not be empty!");
        }
        short val = Short.MIN_VALUE;
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            if (arr[i] <= val) continue;
            val = arr[i];
        }
        return val;
    }

    public static char max(@NonNull char[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        if (arr.length == 0) {
            throw new IllegalArgumentException("Array may not be empty!");
        }
        char val = '\u0000';
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            if (arr[i] <= val) continue;
            val = arr[i];
        }
        return val;
    }

    public static int max(@NonNull int[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        if (arr.length == 0) {
            throw new IllegalArgumentException("Array may not be empty!");
        }
        int val = Integer.MIN_VALUE;
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            if (arr[i] <= val) continue;
            val = arr[i];
        }
        return val;
    }

    public static long max(@NonNull long[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        if (arr.length == 0) {
            throw new IllegalArgumentException("Array may not be empty!");
        }
        long val = Long.MIN_VALUE;
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            if (arr[i] <= val) continue;
            val = arr[i];
        }
        return val;
    }

    public static float max(@NonNull float[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        if (arr.length == 0) {
            throw new IllegalArgumentException("Array may not be empty!");
        }
        float val = Float.MIN_VALUE;
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            if (!(arr[i] > val)) continue;
            val = arr[i];
        }
        return val;
    }

    public static double max(@NonNull double[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        if (arr.length == 0) {
            throw new IllegalArgumentException("Array may not be empty!");
        }
        double val = Double.MIN_VALUE;
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            if (!(arr[i] > val)) continue;
            val = arr[i];
        }
        return val;
    }

    public static byte min(@NonNull byte[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        if (arr.length == 0) {
            throw new IllegalArgumentException("Array may not be empty!");
        }
        byte val = 127;
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            if (arr[i] >= val) continue;
            val = arr[i];
        }
        return val;
    }

    public static short min(@NonNull short[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        if (arr.length == 0) {
            throw new IllegalArgumentException("Array may not be empty!");
        }
        short val = Short.MAX_VALUE;
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            if (arr[i] >= val) continue;
            val = arr[i];
        }
        return val;
    }

    public static char min(@NonNull char[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        if (arr.length == 0) {
            throw new IllegalArgumentException("Array may not be empty!");
        }
        char val = '\uffff';
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            if (arr[i] >= val) continue;
            val = arr[i];
        }
        return val;
    }

    public static int min(@NonNull int[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        if (arr.length == 0) {
            throw new IllegalArgumentException("Array may not be empty!");
        }
        int val = Integer.MAX_VALUE;
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            if (arr[i] >= val) continue;
            val = arr[i];
        }
        return val;
    }

    public static long min(@NonNull long[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        if (arr.length == 0) {
            throw new IllegalArgumentException("Array may not be empty!");
        }
        long val = Long.MAX_VALUE;
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            if (arr[i] >= val) continue;
            val = arr[i];
        }
        return val;
    }

    public static float min(@NonNull float[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        if (arr.length == 0) {
            throw new IllegalArgumentException("Array may not be empty!");
        }
        float val = Float.MAX_VALUE;
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            if (!(arr[i] < val)) continue;
            val = arr[i];
        }
        return val;
    }

    public static double min(@NonNull double[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        if (arr.length == 0) {
            throw new IllegalArgumentException("Array may not be empty!");
        }
        double val = Double.MAX_VALUE;
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            if (!(arr[i] < val)) continue;
            val = arr[i];
        }
        return val;
    }

    public static void swap(@NonNull byte[] arr, int i1, int i2) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        byte val = arr[i1];
        arr[i1] = arr[i2];
        arr[i2] = val;
    }

    public static void swap(@NonNull short[] arr, int i1, int i2) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        short val = arr[i1];
        arr[i1] = arr[i2];
        arr[i2] = val;
    }

    public static void swap(@NonNull char[] arr, int i1, int i2) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        char val = arr[i1];
        arr[i1] = arr[i2];
        arr[i2] = val;
    }

    public static void swap(@NonNull int[] arr, int i1, int i2) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        int val = arr[i1];
        arr[i1] = arr[i2];
        arr[i2] = val;
    }

    public static void swap(@NonNull long[] arr, int i1, int i2) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        long val = arr[i1];
        arr[i1] = arr[i2];
        arr[i2] = val;
    }

    public static void swap(@NonNull float[] arr, int i1, int i2) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        float val = arr[i1];
        arr[i1] = arr[i2];
        arr[i2] = val;
    }

    public static void swap(@NonNull double[] arr, int i1, int i2) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        double val = arr[i1];
        arr[i1] = arr[i2];
        arr[i2] = val;
    }

    public static <T> void swap(@NonNull T[] arr, int i1, int i2) {
        if (arr == null) {
            throw new NullPointerException("arr");
        }
        T val = arr[i1];
        arr[i1] = arr[i2];
        arr[i2] = val;
    }

    private PArrays() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

