/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.util;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import net.daporkchop.lib.common.util.PArrays;
import net.daporkchop.lib.common.util.PorkUtil;

public final class GenericMatcher {
    private static final Map<Key, Class<?>> CACHE = PorkUtil.newSoftCache();

    public static <C> Class<?> find(@NonNull Class<? extends C> thisClass, @NonNull Class<C> superClass, @NonNull String name) {
        if (thisClass == null) {
            throw new NullPointerException("thisClass");
        }
        if (superClass == null) {
            throw new NullPointerException("superClass");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        return CACHE.computeIfAbsent(new Key(thisClass, superClass, name), key -> GenericMatcher.doFind(key.thisClass, key.superClass, key.name));
    }

    public static <T, C> Class<T> uncheckedFind(@NonNull Class<? extends C> thisClass, @NonNull Class<C> superClass, @NonNull String name) {
        if (thisClass == null) {
            throw new NullPointerException("thisClass");
        }
        if (superClass == null) {
            throw new NullPointerException("superClass");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        return GenericMatcher.find(thisClass, superClass, name);
    }

    private static Class<?> doFind(@NonNull Class<?> thisClass, @NonNull Class<?> superClass, @NonNull String name) {
        if (thisClass == null) {
            throw new NullPointerException("thisClass");
        }
        if (superClass == null) {
            throw new NullPointerException("superClass");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        List<Class<?>> hierarchy = GenericMatcher.getHierarchy(thisClass, superClass);
        if (hierarchy == null) {
            throw new IllegalArgumentException(String.format("%s does not inherit from %s!", thisClass, superClass));
        }
        return GenericMatcher.lookup(hierarchy, name);
    }

    private static List<Class<?>> getHierarchy(@NonNull Class<?> current, @NonNull Class<?> superClass) {
        if (current == null) {
            throw new NullPointerException("current");
        }
        if (superClass == null) {
            throw new NullPointerException("superClass");
        }
        List<Object> list = null;
        if (current == superClass) {
            list = new ArrayList();
        } else if (current.getSuperclass() != null) {
            list = GenericMatcher.getHierarchy(current.getSuperclass(), superClass);
        }
        if (list == null && superClass.isInterface()) {
            Class<?> interfaz;
            Class<?>[] interfaces;
            Class<?>[] classArray = interfaces = current.getInterfaces();
            int n = classArray.length;
            for (int i = 0; i < n && (list = GenericMatcher.getHierarchy(interfaz = classArray[i], superClass)) == null; ++i) {
            }
        }
        if (list != null) {
            list.add(current);
        }
        return list;
    }

    private static Class<?> lookup(@NonNull List<Class<?>> hierarchy, @NonNull String name) {
        if (hierarchy == null) {
            throw new NullPointerException("hierarchy");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        for (int i = 0; i < hierarchy.size() - 1; ++i) {
            Class<?> clazz = hierarchy.get(i);
            Class<?> next = hierarchy.get(i + 1);
            int index = -1;
            TypeVariable<Class<?>>[] genericTypes = clazz.getTypeParameters();
            for (int j = genericTypes.length - 1; j >= 0; --j) {
                if (!genericTypes[j].getTypeName().equals(name)) continue;
                index = j;
                break;
            }
            if (index == -1) {
                throw new IllegalArgumentException(String.format("Unknown generic name: \"%s\"", name));
            }
            Type genericSuperType = clazz.isInterface() ? next.getGenericInterfaces()[PArrays.indexOf(next.getInterfaces(), clazz)] : next.getGenericSuperclass();
            if (!(genericSuperType instanceof ParameterizedType)) {
                return Object.class;
            }
            Type actualTypeParam = ((ParameterizedType)genericSuperType).getActualTypeArguments()[index];
            if (actualTypeParam instanceof ParameterizedType) {
                actualTypeParam = ((ParameterizedType)actualTypeParam).getRawType();
            }
            if (actualTypeParam instanceof Class) {
                return (Class)actualTypeParam;
            }
            if (actualTypeParam instanceof GenericArrayType) {
                Type componentType = ((GenericArrayType)actualTypeParam).getGenericComponentType();
                if (componentType instanceof ParameterizedType) {
                    componentType = ((ParameterizedType)componentType).getRawType();
                }
                if (componentType instanceof Class) {
                    return Array.newInstance((Class)componentType, 0).getClass();
                }
            }
            if (!(actualTypeParam instanceof TypeVariable)) continue;
            TypeVariable v = (TypeVariable)actualTypeParam;
            if (!(v.getGenericDeclaration() instanceof Class)) {
                return Object.class;
            }
            name = v.getName();
        }
        return null;
    }

    private GenericMatcher() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static final class Key {
        @NonNull
        protected final Class<?> thisClass;
        @NonNull
        protected final Class<?> superClass;
        @NonNull
        protected final String name;

        public Key(@NonNull Class<?> thisClass, @NonNull Class<?> superClass, @NonNull String name) {
            if (thisClass == null) {
                throw new NullPointerException("thisClass");
            }
            if (superClass == null) {
                throw new NullPointerException("superClass");
            }
            if (name == null) {
                throw new NullPointerException("name");
            }
            this.thisClass = thisClass;
            this.superClass = superClass;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            Class<?> this$thisClass = this.thisClass;
            Class<?> other$thisClass = other.thisClass;
            if (this$thisClass == null ? other$thisClass != null : !this$thisClass.equals(other$thisClass)) {
                return false;
            }
            Class<?> this$superClass = this.superClass;
            Class<?> other$superClass = other.superClass;
            if (this$superClass == null ? other$superClass != null : !this$superClass.equals(other$superClass)) {
                return false;
            }
            String this$name = this.name;
            String other$name = other.name;
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $thisClass = this.thisClass;
            result = result * 59 + ($thisClass == null ? 43 : $thisClass.hashCode());
            Class<?> $superClass = this.superClass;
            result = result * 59 + ($superClass == null ? 43 : $superClass.hashCode());
            String $name = this.name;
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }
    }
}

