/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.system;

import java.lang.reflect.Method;
import java.nio.ByteOrder;
import java.util.Arrays;
import net.daporkchop.lib.common.system.Architecture;
import net.daporkchop.lib.common.system.OperatingSystem;

public final class PlatformInfo {
    public static final Architecture ARCHITECTURE;
    public static final OperatingSystem OPERATING_SYSTEM;
    public static final int JAVA_VERSION;
    public static final boolean IS_32BIT;
    public static final boolean IS_64BIT;
    public static final boolean UNALIGNED;
    public static final ByteOrder BYTE_ORDER;
    public static final boolean IS_LITTLE_ENDIAN;
    public static final boolean IS_BIG_ENDIAN;

    private PlatformInfo() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        String arch;
        switch (arch = System.getProperty("os.arch", "").toLowerCase().replaceAll("[^a-z0-9]+", "")) {
            case "x8664": 
            case "amd64": 
            case "ia32e": 
            case "em64t": 
            case "x64": {
                ARCHITECTURE = Architecture.x86_64;
                break;
            }
            case "x8632": 
            case "x86": 
            case "i386": 
            case "i486": 
            case "i586": 
            case "i686": 
            case "ia32": 
            case "x32": {
                ARCHITECTURE = Architecture.x86;
                break;
            }
            case "ia64": 
            case "itanium64": {
                ARCHITECTURE = Architecture.Itanium;
                break;
            }
            case "sparc": 
            case "sparc32": {
                ARCHITECTURE = Architecture.SPARC;
                break;
            }
            case "sparcv9": 
            case "sparc64": {
                ARCHITECTURE = Architecture.SPARC_64;
                break;
            }
            case "arm": 
            case "arm32": {
                ARCHITECTURE = Architecture.ARM;
                break;
            }
            case "aarch64": {
                ARCHITECTURE = Architecture.AARCH64;
                break;
            }
            case "ppc": 
            case "ppc32": {
                ARCHITECTURE = Architecture.PowerPC;
                break;
            }
            case "ppc64": {
                ARCHITECTURE = Architecture.PowerPC_64;
                break;
            }
            default: {
                ARCHITECTURE = Architecture.UNKNOWN;
            }
        }
        String os = System.getProperty("os.name", "").toLowerCase().replaceAll("[^a-z0-9]+", "");
        OPERATING_SYSTEM = os.startsWith("linux") ? OperatingSystem.Linux : (os.startsWith("freebsd") ? OperatingSystem.FreeBSD : (os.startsWith("openbsd") ? OperatingSystem.OpenBSD : (os.startsWith("netbsd") ? OperatingSystem.NetBSD : (os.startsWith("solaris") ? OperatingSystem.Solaris : (os.startsWith("windows") ? OperatingSystem.Windows : OperatingSystem.UNKNOWN)))));
        int[] version = Arrays.stream(System.getProperty("java.specification.version", "1.6").split("\\.")).mapToInt(Integer::parseInt).toArray();
        JAVA_VERSION = version[0] == 1 ? version[1] : version[0];
        IS_32BIT = ARCHITECTURE.bits() == 32;
        IS_64BIT = ARCHITECTURE.bits() == 64;
        boolean unaligned = false;
        try {
            Class<?> bitsClass = Class.forName("java.nio.Bits", false, ClassLoader.getSystemClassLoader());
            Method unalignedMethod = bitsClass.getDeclaredMethod("unaligned", new Class[0]);
            unalignedMethod.setAccessible(true);
            unaligned = (Boolean)unalignedMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            unaligned = ARCHITECTURE == Architecture.x86 || ARCHITECTURE == Architecture.x86_64;
        }
        finally {
            UNALIGNED = unaligned;
        }
        BYTE_ORDER = ByteOrder.nativeOrder();
        IS_LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
        IS_BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
    }
}

