/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.ref;

import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import net.daporkchop.lib.common.ref.FastLateThreadRef;
import net.daporkchop.lib.common.ref.FastSoftThreadRef;
import net.daporkchop.lib.common.ref.JavaLateThreadRef;
import net.daporkchop.lib.common.ref.JavaSoftThreadRef;
import net.daporkchop.lib.common.ref.Ref;

public interface ThreadRef<T>
extends Ref<T> {
    public static <T> ThreadRef<T> late(@NonNull Supplier<T> supplier) {
        if (supplier == null) {
            throw new NullPointerException("supplier");
        }
        try {
            Class.forName("io.netty.util.concurrent.FastThreadLocal");
            return new FastLateThreadRef<T>(supplier);
        }
        catch (ClassNotFoundException e) {
            return new JavaLateThreadRef<T>(supplier);
        }
    }

    public static <T> ThreadRef<T> soft(@NonNull Supplier<T> supplier) {
        if (supplier == null) {
            throw new NullPointerException("supplier");
        }
        try {
            Class.forName("io.netty.util.concurrent.FastThreadLocal");
            return new FastSoftThreadRef<T>(supplier);
        }
        catch (ClassNotFoundException e) {
            return new JavaSoftThreadRef<T>(supplier);
        }
    }

    public static ThreadRef<Matcher> regex(@NonNull String regex) {
        if (regex == null) {
            throw new NullPointerException("regex");
        }
        return ThreadRef.regex(Pattern.compile(regex));
    }

    public static ThreadRef<Matcher> regex(@NonNull Pattern pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern");
        }
        return ThreadRef.soft(() -> pattern.matcher(""));
    }

    @Override
    public T get();

    public T getUncached();
}

