/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.ref;

import java.lang.ref.SoftReference;
import java.util.Objects;
import java.util.function.Supplier;
import lombok.NonNull;
import net.daporkchop.lib.common.ref.Ref;

public final class SoftLateRef<T>
implements Ref<T> {
    @NonNull
    protected final Supplier<T> factory;
    protected SoftReference<T> ref;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        T val;
        if (this.ref == null || (val = this.ref.get()) == null) {
            SoftLateRef softLateRef = this;
            synchronized (softLateRef) {
                if (this.ref == null || (val = this.ref.get()) == null) {
                    val = Objects.requireNonNull(this.factory.get());
                    this.ref = new SoftReference<T>(val);
                }
            }
        }
        return val;
    }

    protected SoftLateRef(@NonNull Supplier<T> factory) {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        this.factory = factory;
    }
}

