/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.ref;

import java.lang.ref.ReferenceQueue;
import net.daporkchop.lib.common.ref.Ref;
import net.daporkchop.lib.common.ref.attachment.AttachedRef;
import net.daporkchop.lib.common.ref.attachment.SoftAttachedRef;
import net.daporkchop.lib.common.ref.attachment.StrongAttachedRef;
import net.daporkchop.lib.common.ref.attachment.WeakAttachedRef;
import net.daporkchop.lib.common.ref.impl.SoftRef;
import net.daporkchop.lib.common.ref.impl.StrongRef;
import net.daporkchop.lib.common.ref.impl.WeakRef;

public enum ReferenceType {
    STRONG{

        @Override
        public <V> Ref<V> create(V value, ReferenceQueue<? super V> queue) {
            if (queue != null) {
                throw new UnsupportedOperationException("Strong references cannot use a ReferenceQueue!");
            }
            return new StrongRef<V>(value);
        }

        @Override
        public <V, A> AttachedRef<V, A> createAttached(V value, A attachment, ReferenceQueue<? super V> queue) {
            if (queue != null) {
                throw new UnsupportedOperationException("Strong references cannot use a ReferenceQueue!");
            }
            return new StrongAttachedRef<V, A>(value, attachment);
        }
    }
    ,
    SOFT{

        @Override
        public <V> Ref<V> create(V value, ReferenceQueue<? super V> queue) {
            return new SoftRef<V>(value, queue);
        }

        @Override
        public <V, A> AttachedRef<V, A> createAttached(V value, A attachment, ReferenceQueue<? super V> queue) {
            return new SoftAttachedRef<V, A>(value, attachment, queue);
        }
    }
    ,
    WEAK{

        @Override
        public <V> Ref<V> create(V value, ReferenceQueue<? super V> queue) {
            return new WeakRef<V>(value, queue);
        }

        @Override
        public <V, A> AttachedRef<V, A> createAttached(V value, A attachment, ReferenceQueue<? super V> queue) {
            return new WeakAttachedRef<V, A>(value, attachment, queue);
        }
    };


    public <V> Ref<V> create(V value) {
        return this.create(value, null);
    }

    public abstract <V> Ref<V> create(V var1, ReferenceQueue<? super V> var2);

    public <V, A> AttachedRef<V, A> createAttached(V value) {
        return this.createAttached(value, null, null);
    }

    public <V, A> AttachedRef<V, A> createAttached(V value, A attachment) {
        return this.createAttached(value, attachment, null);
    }

    public <V, A> AttachedRef<V, A> createAttached(V value, ReferenceQueue<? super V> queue) {
        return this.createAttached(value, null, queue);
    }

    public abstract <V, A> AttachedRef<V, A> createAttached(V var1, A var2, ReferenceQueue<? super V> var3);
}

