/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.ref;

import java.util.function.Supplier;
import lombok.NonNull;
import net.daporkchop.lib.common.ref.LateReferencedRef;
import net.daporkchop.lib.common.ref.SoftLateRef;

public interface Ref<T>
extends Supplier<T> {
    public static <T> Ref<T> late(@NonNull Supplier<T> factory) {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        return new LateReferencedRef<T>(factory);
    }

    public static <T> Ref<T> soft(@NonNull Supplier<T> factory) {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        return new SoftLateRef<T>(factory);
    }

    @Override
    public T get();
}

