/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.ref;

import java.util.Objects;
import java.util.function.Supplier;
import lombok.NonNull;
import net.daporkchop.lib.common.ref.Ref;

public final class LateReferencedRef<T>
implements Ref<T> {
    @NonNull
    protected Supplier<T> factory;
    protected T value;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        T value = this.value;
        if (value == null) {
            LateReferencedRef lateReferencedRef = this;
            synchronized (lateReferencedRef) {
                value = this.value;
                if (value == null) {
                    this.value = value = Objects.requireNonNull(this.factory.get());
                    this.factory = null;
                }
            }
        }
        return value;
    }

    LateReferencedRef(@NonNull Supplier<T> factory) {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        this.factory = factory;
    }
}

