/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.ref;

import java.lang.ref.SoftReference;
import java.util.Objects;
import java.util.function.Supplier;
import lombok.NonNull;
import net.daporkchop.lib.common.ref.ThreadRef;

public final class JavaSoftThreadRef<T>
implements ThreadRef<T> {
    @NonNull
    private final Supplier<T> factory;
    private final ThreadLocal<SoftReference<T>> threadLocal = new ThreadLocal();

    @Override
    public T get() {
        T val;
        SoftReference<T> ref = this.threadLocal.get();
        if (ref == null || (val = ref.get()) == null) {
            val = Objects.requireNonNull(this.factory.get());
            this.threadLocal.set(new SoftReference<T>(val));
        }
        return val;
    }

    @Override
    public T getUncached() {
        return this.factory.get();
    }

    JavaSoftThreadRef(@NonNull Supplier<T> factory) {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        this.factory = factory;
    }
}

