/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.ref;

import io.netty.util.concurrent.FastThreadLocal;
import java.lang.ref.SoftReference;
import java.util.Objects;
import java.util.function.Supplier;
import lombok.NonNull;
import net.daporkchop.lib.common.ref.ThreadRef;

public final class FastSoftThreadRef<T>
implements ThreadRef<T> {
    @NonNull
    private final Supplier<T> factory;
    private final FastThreadLocal<SoftReference<T>> threadLocal = new FastThreadLocal();

    @Override
    public T get() {
        T val;
        SoftReference<T> ref = this.threadLocal.get();
        if (ref == null || (val = ref.get()) == null) {
            val = Objects.requireNonNull(this.factory.get());
            this.threadLocal.set(new SoftReference<T>(val));
        }
        if (val == null) {
            throw new NullPointerException();
        }
        return val;
    }

    @Override
    public T getUncached() {
        return this.factory.get();
    }

    FastSoftThreadRef(@NonNull Supplier<T> factory) {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        this.factory = factory;
    }
}

