/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.pool.selection;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import lombok.NonNull;
import net.daporkchop.lib.common.pool.selection.SelectionPool;

public final class SingletonSelectionPool<V>
implements SelectionPool<V> {
    @NonNull
    protected final V value;

    @Override
    public V any() {
        return this.value;
    }

    @Override
    public List<V> matching(@NonNull Predicate<V> condition) {
        if (condition == null) {
            throw new NullPointerException("condition");
        }
        return condition.test(this.value) ? Collections.singletonList(this.value) : Collections.emptyList();
    }

    public SingletonSelectionPool(@NonNull V value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.value = value;
    }
}

