/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.pool.selection;

import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import lombok.NonNull;
import net.daporkchop.lib.common.pool.selection.EmptySelectionPool;
import net.daporkchop.lib.common.pool.selection.RandomSelectionPool;
import net.daporkchop.lib.common.pool.selection.RoundRobinSelectionPool;
import net.daporkchop.lib.common.pool.selection.SingletonSelectionPool;

public interface SelectionPool<V>
extends Supplier<V> {
    public static <V> SelectionPool<V> empty() {
        return EmptySelectionPool.getInstance();
    }

    public static <V> SelectionPool<V> singleton(@NonNull V value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        return new SingletonSelectionPool<V>(value);
    }

    public static <V> SelectionPool<V> random(@NonNull V[] values) {
        if (values == null) {
            throw new NullPointerException("values");
        }
        return SelectionPool.random(values, null, false);
    }

    public static <V> SelectionPool<V> random(@NonNull V[] values, Random random) {
        if (values == null) {
            throw new NullPointerException("values");
        }
        return SelectionPool.random(values, random, false);
    }

    public static <V> SelectionPool<V> random(@NonNull V[] values, Random random, boolean skipClone) {
        if (values == null) {
            throw new NullPointerException("values");
        }
        switch (values.length) {
            case 0: {
                return SelectionPool.empty();
            }
            case 1: {
                return SelectionPool.singleton(values[0]);
            }
        }
        return new RandomSelectionPool(skipClone ? values : (Object[])values.clone(), random);
    }

    public static <V> SelectionPool<V> random(@NonNull Stream<V> values) {
        if (values == null) {
            throw new NullPointerException("values");
        }
        return SelectionPool.random(values, null);
    }

    public static <V> SelectionPool<V> random(@NonNull Stream<V> values, Random random) {
        if (values == null) {
            throw new NullPointerException("values");
        }
        return SelectionPool.random(values.toArray(Object[]::new), random, true);
    }

    public static <V> SelectionPool<V> random(@NonNull Collection<V> values) {
        if (values == null) {
            throw new NullPointerException("values");
        }
        return SelectionPool.random(values, null);
    }

    public static <V> SelectionPool<V> random(@NonNull Collection<V> values, Random random) {
        if (values == null) {
            throw new NullPointerException("values");
        }
        return SelectionPool.random(values.toArray(), random, true);
    }

    public static <V> SelectionPool<V> roundRobin(@NonNull V[] values) {
        if (values == null) {
            throw new NullPointerException("values");
        }
        return SelectionPool.roundRobin(values, false);
    }

    public static <V> SelectionPool<V> roundRobin(@NonNull V[] values, boolean skipClone) {
        if (values == null) {
            throw new NullPointerException("values");
        }
        switch (values.length) {
            case 0: {
                return SelectionPool.empty();
            }
            case 1: {
                return SelectionPool.singleton(values[0]);
            }
        }
        return new RoundRobinSelectionPool(skipClone ? values : (Object[])values.clone());
    }

    public static <V> SelectionPool<V> roundRobin(@NonNull Stream<V> values) {
        if (values == null) {
            throw new NullPointerException("values");
        }
        return SelectionPool.roundRobin(values.toArray(Object[]::new), true);
    }

    public static <V> SelectionPool<V> roundRobin(@NonNull Collection<V> values) {
        if (values == null) {
            throw new NullPointerException("values");
        }
        return SelectionPool.roundRobin(values.toArray(), true);
    }

    public V any();

    public List<V> matching(@NonNull Predicate<V> var1);

    @Override
    default public V get() {
        return this.any();
    }
}

