/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.pool.selection;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.NonNull;
import net.daporkchop.lib.common.pool.selection.SelectionPool;
import net.daporkchop.lib.unsafe.PUnsafe;

public final class RoundRobinSelectionPool<V>
implements SelectionPool<V> {
    protected static final long STEP_OFFSET = PUnsafe.pork_getOffset(RoundRobinSelectionPool.class, "step");
    protected final Object[] values;
    protected final int valueCount;
    protected volatile int step;

    protected RoundRobinSelectionPool(@NonNull Object[] values) {
        if (values == null) {
            throw new NullPointerException("values");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("Must have at least 1 value!");
        }
        this.values = values;
        this.valueCount = values.length;
    }

    @Override
    public V any() {
        int nextIndex;
        int index;
        do {
            if ((nextIndex = (index = PUnsafe.getIntVolatile(this, STEP_OFFSET)) + 1) < this.valueCount) continue;
            nextIndex = 0;
        } while (!PUnsafe.compareAndSwapInt(this, STEP_OFFSET, index, nextIndex));
        return (V)this.values[nextIndex];
    }

    @Override
    public List<V> matching(@NonNull Predicate<V> condition) {
        if (condition == null) {
            throw new NullPointerException("condition");
        }
        return Arrays.stream(this.values).filter(condition).collect(Collectors.toList());
    }
}

