/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.pool.selection;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.NonNull;
import net.daporkchop.lib.common.pool.selection.SelectionPool;

public final class RandomSelectionPool<V>
implements SelectionPool<V> {
    @NonNull
    protected final Object[] values;
    protected final Random random;
    protected final int valueCount;

    protected RandomSelectionPool(@NonNull Object[] values, Random random) {
        if (values == null) {
            throw new NullPointerException("values");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("Must have at least 1 value!");
        }
        this.values = values;
        this.random = random;
        this.valueCount = values.length;
    }

    @Override
    public V any() {
        return (V)this.values[this.random().nextInt(this.values.length)];
    }

    @Override
    public List<V> matching(@NonNull Predicate<V> condition) {
        if (condition == null) {
            throw new NullPointerException("condition");
        }
        return Arrays.stream(this.values).filter(condition).collect(Collectors.toList());
    }

    protected Random random() {
        return this.random == null ? ThreadLocalRandom.current() : this.random;
    }
}

