/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.pool.handle;

import io.netty.util.Recycler;
import java.util.function.Supplier;
import lombok.NonNull;
import net.daporkchop.lib.common.misc.refcount.AbstractRefCounted;
import net.daporkchop.lib.common.pool.handle.Handle;
import net.daporkchop.lib.common.pool.handle.HandledPool;
import net.daporkchop.lib.unsafe.util.exception.AlreadyReleasedException;

final class RecyclingHandledPool<V>
implements HandledPool<V> {
    private final Recycler<Wrapper<V>> recycler;

    public RecyclingHandledPool(final @NonNull Supplier<V> factory, int maxCapacityPerThread) {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        this.recycler = new Recycler<Wrapper<V>>(maxCapacityPerThread){

            @Override
            protected Wrapper<V> newObject(Recycler.Handle<Wrapper<V>> handle) {
                return new Wrapper(handle, factory.get());
            }
        };
    }

    @Override
    public Handle<V> get() {
        return new HandleImpl<V>(this.recycler.get());
    }

    private static final class HandleImpl<V>
    extends AbstractRefCounted
    implements Handle<V> {
        @NonNull
        private final Wrapper<V> wrapper;

        @Override
        protected void doRelease() {
            ((Wrapper)this.wrapper).handle.recycle(this.wrapper);
        }

        @Override
        public V get() {
            this.ensureNotReleased();
            return (V)((Wrapper)this.wrapper).value;
        }

        @Override
        public Handle<V> retain() throws AlreadyReleasedException {
            super.retain();
            return this;
        }

        public HandleImpl(@NonNull Wrapper<V> wrapper) {
            if (wrapper == null) {
                throw new NullPointerException("wrapper");
            }
            this.wrapper = wrapper;
        }
    }

    private static final class Wrapper<V> {
        @NonNull
        private final Recycler.Handle<Wrapper<V>> handle;
        @NonNull
        private final V value;

        public Wrapper(@NonNull Recycler.Handle<Wrapper<V>> handle, @NonNull V value) {
            if (handle == null) {
                throw new NullPointerException("handle");
            }
            if (value == null) {
                throw new NullPointerException("value");
            }
            this.handle = handle;
            this.value = value;
        }
    }
}

