/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.pool.handle;

import java.util.function.Supplier;
import lombok.NonNull;
import net.daporkchop.lib.common.pool.handle.BasicHandledPool;
import net.daporkchop.lib.common.pool.handle.Handle;
import net.daporkchop.lib.common.pool.handle.HandledPool;
import net.daporkchop.lib.common.ref.ReferenceType;

final class JavaRecyclingHandledPool<V>
implements HandledPool<V> {
    private final ThreadLocal<BasicHandledPool<V>> tl;

    public JavaRecyclingHandledPool(@NonNull Supplier<V> factory, int maxCapacityPerThread) {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        this.tl = ThreadLocal.withInitial(() -> new BasicHandledPool(factory, ReferenceType.STRONG, maxCapacityPerThread));
    }

    @Override
    public Handle<V> get() {
        return this.tl.get().get();
    }
}

